/******************************** CPPFile *****************************

* FileName [StdcAst.cpp]

* PackageName [parser]

* Synopsis [Method definitions of various top-level C AST node class.]

* SeeAlso [StdcAst.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <map>
using namespace std;

#include "Node.h"
#include "DFSAdapter.h"
using namespace magic;

/*********************************************************************/
//methods for class Decl
/*********************************************************************/
void Decl::Apply(DFSAdapter &a) const 
{ 
  a.caseDecl(*this); 
}

/*********************************************************************/
//methods for class Proc
/*********************************************************************/
void Proc::Apply(DFSAdapter &a) const 
{ 
  a.caseProc(*this); 
}

/*********************************************************************/
//methods for class StdcFile
/*********************************************************************/
void StdcFile::Apply(DFSAdapter &a) const 
{ 
  a.caseStdcFile(*this); 
}

/*********************************************************************/
//end of StdcAst.cpp
/*********************************************************************/
