/**************************** CPPHeaderFile ***************************

* FileName [SeawManager.h]

* PackageName [main]

* Synopsis [Header file for SeawManager class.]

* Description [This class manages all existing SE-AW operators and
* formulas.]

* SeeAlso [SeawManager.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __SEAWMANAGER_H__
#define __SEAWMANAGER_H__

namespace magic {

//other classes needed
class OmegaOp;
class BasicSeaw;
class SeawFormula;

class SeawManager
{
 private:
  //map from names to omega operators
  static map<string,OmegaOp> omegaMap;

  //map from names to SE-AW formulas
  static map<string,SeawFormula> seawMap;

  //map from formula names to propositions
  static map< string,set<Expr> > propMap;

  //map from formula names to actions
  static map< string,set<Action> > actMap;

  static void ComputeReturnActions(const string &name,set<Action> &res);
  static void ComputeAssignActions(const string &name,set<Action> &res);

 public:
  static const map<string,OmegaOp> &GetOmegaMap() { return omegaMap; }

  static void Initialise();
  static void AddOmega(const string &n,const OmegaOp &o);
  static void AddSeaw(const string &n,const SeawFormula &s);
  static void SanityCheck();
  static const set<Expr> &GetProps(const string &name);
  static const set<Action> &GetActions(const string &name);
  static void GetAssignActions(const string &name,const Expr &lhs,const Expr &rhs,
			       const list<string> &params,const set<Expr> &context,
			       set<Action> &res);
  static void GetReturnActions(const string &name,const Expr &expr,const list<string> &params,
			       const set<Expr> &context,set<Action> &res);
  static void GetAssignActExprs(const string &name,set< pair<Expr,Expr> > &res);
  static void GetRetActExprs(const string &name,set<Expr> &res);
  static const BasicSeaw *GetBasicSeaw(const string &name);
};

} //namespace magic

#endif //__SEAWMANAGER_H__

/*********************************************************************/
//end of SeawManager.h
/*********************************************************************/
