/**************************** CPPHeaderFile ***************************

* FileName [ProgInfo.h]

* PackageName [parser]

* Synopsis [Header file for ProgInfo class.]

* Description [This class encapsulates information about a concurrent
* C program provided via specification files.]

* SeeAlso [ProgInfo.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __PROGINFO_H__
#define __PROGINFO_H__

namespace magic {

class ProgInfo
{
 private:
  //the name of the program
  string name;

  //the components procedures
  vector<string> procs;

  //the abstractions
  list<ProgAbs> abstractions;

 public:
  ProgInfo() {}
  ProgInfo(const string &n,const list<string> &p);
  ProgInfo(const string &n,const list<string> &p,const list<ProgAbs> &a);
  ~ProgInfo() {}
  ProgInfo(const ProgInfo &rhs) { *this = rhs; }

  const ProgInfo &operator = (const ProgInfo &rhs);

  string GetName() const { return name; }
  const vector<string> &GetProcs() const { return procs; }
  const list<ProgAbs> &GetAbstractions() const { return abstractions; }

  void AddProgInfo(const ProgInfo &p);
};

} //namespace magic

#endif //__PROGINFO_H__

/*********************************************************************/
//end of ProgInfo.h
/*********************************************************************/
