/******************************** CPPFile *****************************

* FileName [ProgInfo.cpp]

* PackageName [parser]

* Synopsis [Method definitions of ProgInfo class.]

* SeeAlso [ProgInfo.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <vector>
#include <set>
#include <map>
using namespace std;

#include "Util.h"
#include "Node.h"
#include "ProgAbs.h"
#include "ProgInfo.h"
using namespace magic;

/*********************************************************************/
//constructors and destructors
/*********************************************************************/
ProgInfo::ProgInfo(const string &n,const list<string> &p)
{
  name = n;
  procs.insert(procs.end(),p.begin(),p.end());
}

ProgInfo::ProgInfo(const string &n,const list<string> &p,const list<ProgAbs> &a)
{
  name = n;
  procs.insert(procs.end(),p.begin(),p.end());
  abstractions = a;
}

/*********************************************************************/
//operators
/*********************************************************************/
const ProgInfo &ProgInfo::operator = (const ProgInfo &rhs)
{
  name = rhs.name;
  procs = rhs.procs;
  abstractions = rhs.abstractions;
  return *this;
}

/*********************************************************************/
//append info from another program info
/*********************************************************************/
void ProgInfo::AddProgInfo(const ProgInfo &p)
{
  assert(name == p.name);
  assert(procs == p.procs);
  abstractions.insert(abstractions.end(),p.abstractions.begin(),p.abstractions.end());
}

/*********************************************************************/
//end of ProgInfo.cpp
/*********************************************************************/
