/**************************** CPPHeaderFile ***************************

* FileName [ProgAbs.h]

* PackageName [parser]

* Synopsis [Header file for ProgAbs class.]

* Description [This class encapsulates a program abstraction.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __PROGABS_H__
#define __PROGABS_H__

namespace magic {

//other classes needed
class Expr;

class ProgAbs
{
 private:
  //the name of this abstraction
  string name;

  //the guards
  vector<Expr> guards;

  //the name of the abstraction lts
  string ltsName;

 public:
  ProgAbs() {}
  ProgAbs(const string &n,const ExprList &g,const string &l);
  ProgAbs(const ProgAbs &rhs) { *this = rhs; }
  const ProgAbs &operator = (const ProgAbs &rhs);

  string GetName() const { return name; }
  const vector<Expr> &GetGuards() const { return guards; }
  string GetLtsName() const { return ltsName; }
};

} //namespace magic

#endif //__PROGABS_H__

/*********************************************************************/
//end of ProgAbs.h
/*********************************************************************/
