/******************************** CPPFile *****************************

* FileName [ProgAbs.cpp]

* PackageName [parser]

* Synopsis [Method definitions of ProgAbs class.]

* SeeAlso [ProgAbs.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <vector>
#include <map>
using namespace std;

#include "Node.h"
#include "ProgAbs.h"
using namespace magic;

/*********************************************************************/
//constructors and destructors
/*********************************************************************/
ProgAbs::ProgAbs(const string &n,const ExprList &g,const string &l)
{
  name = n;
  for(list<BasicExpr*>::const_iterator i = g.data.begin();i != g.data.end();++i) {
    guards.push_back(Expr(*i));
  }
  ltsName = l;
}

/*********************************************************************/
//operators
/*********************************************************************/
const ProgAbs &ProgAbs::operator = (const ProgAbs &rhs)
{
  name = rhs.name;  
  guards = rhs.guards;
  ltsName = rhs.ltsName;
  return *this;
}

/*********************************************************************/
//end of ProgAbs.cpp
/*********************************************************************/
