/**************************** CPPHeaderFile ***************************

* FileName [ProcAddInfo.h]

* PackageName [parser]

* Synopsis [Header file for ProcAddInfo class.]

* Description [This class encapsulates additional information about C
* procedures provided via specification files.]

* SeeAlso [ProcAddInfo.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __PROCADDINFO_H__
#define __PROCADDINFO_H__

namespace magic {

//other classes needed
class Alias;
class ProcAbs;

class ProcAddInfo
{
 private:
  //the name of the procedure
  string name;
  //the list of predicates
  ExprList preds;
  //the list of guards for fair loops
  ExprList fairLoops;
  //the list of procedure names to be inlined
  set<string> inlines;
  //the list of aliasing scenarios
  list<Alias> aliases;
  //the list of abstractions for this procedure
  list<ProcAbs> abstractions;
  //the depth of the context to be maintained
  unsigned context;

 public:
  ProcAddInfo() { context = 0; }
  ProcAddInfo(const ProcAddInfo &rhs) { *this = rhs; }
  ~ProcAddInfo() {}
  const ProcAddInfo &operator = (const ProcAddInfo &rhs);

  void SetName(const string &n) { name = n; }
  void AddPreds(const ExprList &p);
  void AddFairLoops(const ExprList &f);
  void AddInlines(const list<string> &i);
  void AddAlias(const list<Alias> &a);
  void AddAbstraction(const list<ProcAbs> &p);
  void SetContext(const unsigned c);
  void AddProcAddInfo(const ProcAddInfo &p);

  string &GetName() { return name; }

  friend class ProcInfo;
};

} //namespace magic

#endif //__PROCADDINFO_H__

/*********************************************************************/
//end of ProcAddInfo.h
/*********************************************************************/
