/******************************** CPPFile *****************************

* FileName [ProcAddInfo.cpp]

* PackageName [parser]

* Synopsis [Method definitions of ProcAddInfo class.]

* SeeAlso [ProcAddInfo.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <map>
using namespace std;

#include "Node.h"
#include "Alias.h"
#include "ProcAbs.h"
#include "ProcAddInfo.h"
using namespace magic;

/*********************************************************************/
//operators
/*********************************************************************/
const ProcAddInfo &ProcAddInfo::operator = (const ProcAddInfo &rhs)
{
  name = rhs.name;
  preds = rhs.preds;
  fairLoops = rhs.fairLoops;
  inlines = rhs.inlines;
  aliases = rhs.aliases;
  abstractions = rhs.abstractions;
  context = rhs.context;
  return *this;
}

/*********************************************************************/
//other methods
/*********************************************************************/
void ProcAddInfo::AddPreds(const ExprList &p) 
{ 
  preds.AddExprList(p); 
}

void ProcAddInfo::AddFairLoops(const ExprList &f) 
{ 
  fairLoops.AddExprList(f); 
}

void ProcAddInfo::AddInlines(const list<string> &i) 
{ 
  inlines.insert(i.begin(),i.end());
}

void ProcAddInfo::AddAlias(const list<Alias> &a)
{
  aliases.insert(aliases.end(),a.begin(),a.end());
}

void ProcAddInfo::AddAbstraction(const list<ProcAbs> &p)
{
  abstractions.insert(abstractions.end(),p.begin(),p.end());
}

void ProcAddInfo::SetContext(const unsigned c)
{
  context = c;
}

/*********************************************************************/
//append info from another proc add info
/*********************************************************************/
void ProcAddInfo::AddProcAddInfo(const ProcAddInfo &p)
{
  assert(name == p.name);
  preds.AddExprList(p.preds);
  fairLoops.AddExprList(p.fairLoops);
  inlines.insert(p.inlines.begin(),p.inlines.end());
  aliases.insert(aliases.end(),p.aliases.begin(),p.aliases.end());
  abstractions.insert(abstractions.end(),p.abstractions.begin(),p.abstractions.end());
  context = p.context;
}

/*********************************************************************/
//end of ProcAddInfo.cpp
/*********************************************************************/
