/**************************** CPPHeaderFile ***************************

* FileName [ProcAbs.h]

* PackageName [parser]

* Synopsis [Header file for ProcAbs class.]

* Description [This class encapsulates a procedure abstraction.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __PROCABS_H__
#define __PROCABS_H__

namespace magic {

//other classes needed
class Expr;

class ProcAbs
{
 private:
  //the name of this abstraction
  string name;

  //the guard
  Expr guard;

  //the name of the abstraction lts
  string ltsName;

 public:
  ProcAbs() {}
  ProcAbs(const string &n,const Expr &g,const string &l) 
    : name(n),guard(g),ltsName(l) {}
  ProcAbs(const ProcAbs &rhs) { *this = rhs; }
  const ProcAbs &operator = (const ProcAbs &rhs);
  bool operator == (const ProcAbs &rhs) const;
  bool operator < (const ProcAbs &rhs) const;

  string GetName() const { return name; }
  const Expr &GetGuard() const { return guard; }
  string GetLtsName() const { return ltsName; }
  
  bool AbstractionPossible(const list<Expr> &args,const set<Expr> &context) const;
  string ToString() const;

  static ProcAbs GetEpsilonAbstraction();
};

} //namespace magic

#endif //__PROCABS_H__

/*********************************************************************/
//end of ProcAbs.h
/*********************************************************************/
