/******************************** CPPFile *****************************

* FileName [ProcAbs.cpp]

* PackageName [parser]

* Synopsis [Method definitions of ProcAbs class.]

* SeeAlso [ProcAbs.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cstdio>
#include <cassert>
#include <string>
#include <list>
#include <set>
#include <vector>
#include <map>
using namespace std;

#include "Node.h"
#include "ExprManager.h"
#include "Database.h"
#include "ProcAbs.h"
using namespace magic;

/*********************************************************************/
//operators
/*********************************************************************/
const ProcAbs &ProcAbs::operator = (const ProcAbs &rhs)
{
  name = rhs.name;  
  guard = rhs.guard;
  ltsName = rhs.ltsName;
  return *this;
}

bool ProcAbs::operator == (const ProcAbs &rhs) const
{
  return ((guard == rhs.guard) && (ltsName == rhs.ltsName));
}

bool ProcAbs::operator < (const ProcAbs &rhs) const
{
  if(!(guard == rhs.guard)) return (guard < rhs.guard);
  else return (ltsName < rhs.ltsName);
}

/*********************************************************************/
//return an abstraction that abstracts a procedure with the epsilon
//LTS under all conditions.
/*********************************************************************/
ProcAbs ProcAbs::GetEpsilonAbstraction()
{
  Expr g = ExprManager::GetIntConstExpr(1);
  return ProcAbs(Database::EPSILON_PROC_ABS,g,Database::EPSILON_SPEC);
}

/*********************************************************************/
//return true if the guard of this procedure abstraction could be
//satisfied and false otherwise. the first argument is the list of
//arguments to the procedure call and the second argument is the
//context under which the procedure call occurs.
/*********************************************************************/
bool ProcAbs::AbstractionPossible(const list<Expr> &args,const set<Expr> &context) const
{
  Expr newGuard = ExprManager::ReplaceDummyVarsOne(guard,args);
  Expr neg = ExprManager::NegateExpr(newGuard);
  set<Expr> elist; elist.insert(neg);
  return !ExprManager::ProveImplies(context,elist);
}

/*********************************************************************/
//convert to string representation representation
/*********************************************************************/
string ProcAbs::ToString() const
{
  return name + ":" + guard.ToString() + ":" + ltsName;
}

/*********************************************************************/
//end of ProcAbs.cpp
/*********************************************************************/
