/**************************** CPPHeaderFile ***************************

* FileName [Node.h]

* PackageName [parser]

* Synopsis [Header file for Node class.]

* Description [This class encapsulates a node in the AST.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __NODE_H__
#define __NODE_H__

namespace magic {

//other classes needed
class DFSAdapter;

class Node;

class Expr;
class ExprList;
class IdExpr;
class IntConstExpr;
class ConstExpr;
class StrExpr;
class StrStrExpr;
class StmtExpr;
class BrackExpr;
class ParExpr;
class DotExpr;
class ArrowExpr;
class IncExpr;
class UnaryExpr;
class EmptyExpr;
class BinaryExpr;
class QuestExpr;
class AssignExpr;

class Stmt;
class StmtList;
class LabelStmt;
class CaseStmt;
class DefaultStmt;
class CompStmt;
class ExprStmt;
class EmptyStmt;
class IfStmt;
class SwitchStmt;
class WhileStmt;
class DoStmt;
class ForStmt;
class GotoStmt;
class ContinueStmt;
class BreakStmt;
class ReturnStmt;

class Decl;
class Proc;
class StdcFile;

class Node
{
 public:
  //virtual destructor
  virtual ~Node() {}

  //get a string representation
  virtual string ToString() const = 0;

  //used to walk a AST
  virtual void Apply(DFSAdapter &a) const = 0;

  //create a new copy of the AST rooted at this node
  virtual Node *Clone() const = 0;

  //clean up the subtree rooted at this node
  virtual void Cleanup() = 0;
};

} //namespace magic

/*********************************************************************/
//include headers for concrete ast classes
/*********************************************************************/
#include "Expr.h"
#include "Stmt.h"
#include "StdcAst.h"
#include "ExprManager.h"

#endif //__NODE_H__

/*********************************************************************/
//end of Node.h
/*********************************************************************/
