%{
#include <cstdio>
#include <cassert>
#include <gmp.h>
#include <string>
#include <list>
#include <vector>
#include <set>
#include <map>
using namespace std;

#include "BigInt.h"
#include "Util.h"
#include "Node.h"
#include "Action.h"
#include "Predicate.h"
#include "PredSet.h"
#include "ContLoc.h"
#include "ImplState.h"
#include "LocalAbsLts.h"
#include "Component.h"
#include "ProcManager.h"
using namespace magic;

int Modellex();
void Modelerror(char *s);
__attribute__ ((noreturn)) void GlobalShutdown(int sig);

namespace magic
{

class OutTrans
{
 public:
  PVal oldPV;
  short oldSS,oldSI;
  short actId;
  ContLoc *newLoc;
  PVal newPV;
  short newSS,newSI;

  OutTrans(const PVal &op,const short oss,const short osi,
	   const short aid,ContLoc *nl,const PVal &np,
	   const short nss,const short nsi) 
    : oldPV(op),oldSS(oss),oldSI(osi),actId(aid),
    newLoc(nl),newPV(np),newSS(nss),newSI(nsi) {}
  OutTrans(const OutTrans &rhs) { *this = rhs; }

  const OutTrans &operator = (const OutTrans &rhs) {
    oldPV = rhs.oldPV;
    oldSS = rhs.oldSS;
    oldSI = rhs.oldSI;
    actId = rhs.actId;
    newLoc = rhs.newLoc;
    newPV = rhs.newPV;
    newSS = rhs.newSS;
    newSI = rhs.newSI;
    return *this;
  }
  
  bool operator == (const OutTrans &rhs) const {
    return ((oldPV == rhs.oldPV) && (oldSS == rhs.oldSS) &&
	    (oldSI == rhs.oldSI) && (actId == rhs.actId) &&
	    (newLoc == rhs.newLoc) && (newPV == rhs.newPV) &&
	    (newSS == rhs.newSS) && (newSI == rhs.newSI));
  }

  bool operator < (const OutTrans &rhs) const {
    if(oldPV < rhs.oldPV) return true;
    if(rhs.oldPV < oldPV) return false;
    if(oldSS < rhs.oldSS) return true;
    if(rhs.oldSS < oldSS) return false;
    if(oldSI < rhs.oldSI) return true;
    if(rhs.oldSI < oldSI) return false;
    if(actId < rhs.actId) return true;
    if(rhs.actId < actId) return false;
    if(newLoc < rhs.newLoc) return true;
    if(rhs.newLoc < newLoc) return false;
    if(newPV < rhs.newPV) return true;
    if(rhs.newPV < newPV) return false;
    if(newSS < rhs.newSS) return true;
    if(rhs.newSS < newSS) return false;
    return (newSI < rhs.newSI);
  }

  string ToString() const {
    char buf[256];
    snprintf(buf,256,"%s %hd %hd %hd %p %s %hd %hd",oldPV.ToString().c_str(),
	     oldSS,oldSI,actId,newLoc,newPV.ToString().c_str(),newSS,newSI);
    return string(buf);
  }      
};

} //namespace magic

string ModelParserStr;
int ModelParserPtr;
int ModelParserInt;
ProcManager *mpProcManager;
set<const ImplState*> *mpReachImpl;
set<Action> *mpAbsActs;
set<Action> *mpNewChanActs;
%}

%union {
  int ival;
  magic::BigInt *biptr;
  set<magic::Expr> *esptr;
  set<magic::OutTrans> *otsptr;
}

%token MAGIC_MODEL_STATE
%token MAGIC_MODEL_TRANS
%token MAGIC_MODEL_NULL_PTR
%token MAGIC_MODEL_PTR
%token MAGIC_MODEL_ACTION_NONE
%token MAGIC_MODEL_BIG_INT
%token MAGIC_MODEL_MAX_BIG_INT
%token MAGIC_MODEL_INT

%expect 0

%type <ival> model_ptr model_short
%type <biptr> model_big_int
%type <esptr> props prop_list
%type <otsptr> loc_outs loc_out_list

%start model

%%

model 
        : MAGIC_MODEL_STATE states_and_actions {} 
        | MAGIC_MODEL_TRANS transitions {} 
        ;

states_and_actions : states actions {};

states
        : MAGIC_MODEL_NULL_PTR {}
        | state_list MAGIC_MODEL_NULL_PTR {}
        ;

state_list : state {} | state_list state {}; 

state : model_ptr model_big_int model_short model_short props
        {
	  assert(($1 != 0) && ($2 != NULL) && ($5 != NULL));
	  ContLoc *loc = (ContLoc*)($1);
	  const ImplState *is = loc->GetImplState(*$2,$3,$4);
	  mpReachImpl->insert(is);
	  loc->SetPropositions(is,*$5);
	  delete $2; delete $5;	  
        }
        ;

props
        : MAGIC_MODEL_NULL_PTR { $$ = new set<Expr>(); }
        | prop_list MAGIC_MODEL_NULL_PTR { $$ = $1; }
        ;


prop_list
        : model_ptr
        {
	  assert($1 != 0);
	  $$ = new set<Expr>();
	  $$->insert(magic::Expr((magic::BasicExpr*)($1)));
	}
        | prop_list model_ptr
        {
	  assert(($1 != NULL) && ($2 != 0));
	  $$ = $1;
	  $$->insert(magic::Expr((magic::BasicExpr*)($2)));
	}
        ;

actions 
        : MAGIC_MODEL_ACTION_NONE {}
        | action_list MAGIC_MODEL_ACTION_NONE {}
        ; 

action_list
        : model_short
        {
	  Action act($1);	 
	  if(act.IsBcast() || act.IsSend() ||
	     (act.IsAssign() && mpProcManager->IsConcGlobalVar(act.GetLhsExpr()))) mpNewChanActs->insert(act);
	  mpAbsActs->insert(act);
	}
        | action_list model_short
        {
	  Action act($2);	 
	  if(act.IsBcast() || act.IsSend() ||
	     (act.IsAssign() && mpProcManager->IsConcGlobalVar(act.GetLhsExpr()))) mpNewChanActs->insert(act);
	  mpAbsActs->insert(act);
	}
        ;

transitions
        : MAGIC_MODEL_NULL_PTR {}
        | trans_list MAGIC_MODEL_NULL_PTR {}
        ; 

trans_list : loc_trans {} | trans_list loc_trans {} ;

loc_trans : model_ptr loc_outs 
        {
	  assert(($1 != 0) && ($2 != NULL));
	  ContLoc *oldLoc = (ContLoc*)($1);
	  map< string,map< Action,set<const ImplState*> > > succMap;
	  for(set<magic::OutTrans>::const_iterator i = $2->begin();i != $2->end();++i) {	    
	    const ImplState *oldState = oldLoc->GetImplState(i->oldPV,i->oldSS,i->oldSI);
	    string oldKey = oldState->GetKey();
	    const ImplState *newState = i->newLoc->GetImplState(i->newPV,i->newSS,i->newSI);
	    succMap[oldKey][Action(i->actId)].insert(newState);
	  }
	  for(map< string,map< Action,set<const ImplState*> > >::const_iterator i = succMap.begin();i != succMap.end();++i) {
	    oldLoc->AddSuccsAndActions(i->first,i->second);
	  }
	  delete $2;
	}
        ;

loc_outs 
        : '<' '>' model_short model_short MAGIC_MODEL_ACTION_NONE MAGIC_MODEL_NULL_PTR '<' '>' model_short model_short
        { 
	  assert(($3 == -1) && ($4 == -1) && ($9 == -1) && ($10 == -1));
	  $$ = new set<magic::OutTrans>(); 
	}
        | loc_out_list '<' '>' model_short model_short MAGIC_MODEL_ACTION_NONE MAGIC_MODEL_NULL_PTR '<' '>' model_short model_short
        { 
	  assert(($4 == -1) && ($5 == -1) && ($10 == -1) && ($11 == -1));
	  $$ = $1;
	}
        ;


loc_out_list
        : model_big_int model_short model_short model_short model_ptr model_big_int model_short model_short
        {
	  assert(($1 != NULL) && ($6 != NULL));
	  $$ = new set<magic::OutTrans>();
	  $$->insert(magic::OutTrans(*$1,$2,$3,$4,(ContLoc*)($5),*$6,$7,$8));
	  delete $1; delete $6;
	}
        | loc_out_list model_big_int model_short model_short model_short model_ptr model_big_int model_short model_short
        {
	  assert(($1 != NULL) && ($2 != NULL) && ($7 != NULL));
	  $$ = $1;
	  $$->insert(magic::OutTrans(*$2,$3,$4,$5,(ContLoc*)($6),*$7,$8,$9));
	  delete $2; delete $7;
	}
        ;

model_ptr : MAGIC_MODEL_PTR { $$ = ModelParserPtr; };

model_big_int : '<' MAGIC_MODEL_INT '>' { $$ = new BigInt(ModelParserStr,10); };

model_short : MAGIC_MODEL_INT { $$ = ModelParserInt; };

%%

void Modelerror(char *s)
{
  fflush(stdout);
  Util::Message(2,"\nERROR: ill-formed model file ...\n"
		"HINT: rm -f implstate* impltrans* and rerun magic\n");
  GlobalShutdown(-1);
}

/*********************************************************************/
//end of ModelParser.cpp
/*********************************************************************/
