D                       [0-9]
H                       [a-fA-F0-9]

%{
#include <cassert>
#include <gmp.h>
#include <string>
#include <list>
#include <set>
#include <map>
#include <vector>
using namespace std;

#include "BigInt.h"
#include "Node.h"
#include "Action.h"
#include "Predicate.h"
#include "PredSet.h"
#include "ContLoc.h"

namespace magic
{

class OutTrans
{
 public:
  ContLoc *newLoc;
  PVal oldPV,newPV;
  short oldSS,oldSI,newSS,newSI,actId;
};

} //namespace magic

#include "ModelParser.h"
using namespace magic;

extern string ModelParserStr;
extern int ModelParserPtr;
extern int ModelParserInt;
%}

%option noyywrap

%%

"#MAGIC_STATE_FILE#" { 
                       return MAGIC_MODEL_STATE; 
                     }
"#MAGIC_TRANS_FILE#" { 
                       return MAGIC_MODEL_TRANS; 
                     }
"0x0"                { 
                       return MAGIC_MODEL_NULL_PTR; 
                     }
0x{H}+               { 
                       ModelParserPtr = strtol(Modeltext,NULL,16); 
		       return MAGIC_MODEL_PTR; 
                     }
"()"                 { 
		       return MAGIC_MODEL_ACTION_NONE; 
                     }
[+-]?{D}+            { 
                       ModelParserStr = Modeltext; 
		       ModelParserInt = strtol(Modeltext,NULL,10); 
		       return MAGIC_MODEL_INT; 
                     }
"<"                  { 
                       return '<'; 
                     }
">"                  { 
		       return '>'; 
                     }

(\n|.)               {}    

%%

//to prevent the warning message that yyunput() is unused
void ModelDummy() { yyunput(0,NULL); }

/*********************************************************************/
//end of ModelLexer.cpp
/*********************************************************************/
