/**************************** CPPHeaderFile ***************************

* FileName [LtsTrans.h]

* PackageName [parser]

* Synopsis [Header file for LtsTrans class.]

* Description [This class encapsulates an LTS transition.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __LTSTRANS_H__
#define __LTSTRANS_H__

namespace magic {

class LtsTrans
{
 private:
  //the initial and final states
  string initState,finalState;
  //the action
  Action action;
 public:
  LtsTrans() { assert(false); }
  //for creating a complete transition
  LtsTrans(const string &i,const string &f,const Action &a);
  //for creating a transition without initial state
  LtsTrans(const string &f,const Action &a);
  //for creating a transition without initial state or final state
  LtsTrans(const Action &a);
  LtsTrans(const LtsTrans &rhs) { *this = rhs; }
  ~LtsTrans() {}
  const LtsTrans &operator = (const LtsTrans &rhs);
  bool operator == (const LtsTrans &rhs) const;
  bool operator < (const LtsTrans &rhs) const;

  void SetInitState(const string &i) { assert(initState == ""); initState = i; }
  string GetInitState() const { return initState; }
  void SetFinalState(const string &f) { assert(finalState == ""); finalState = f; }
  string GetFinalState() const { return finalState; }
  Action GetAction() const { return action; }

  string ToString() const;
};

} //namespace magic

#endif //__LTSTRANS_H__

/*********************************************************************/
//end of LtsTrans.h
/*********************************************************************/
