/******************************** CPPFile *****************************

* FileName [LtsTrans.cpp]

* PackageName [parser]

* Synopsis [Method definitions of LtsTrans class.]

* SeeAlso [LtsTrans.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <vector>
#include <map>
using namespace std;

#include "Node.h"
#include "Action.h"
#include "Database.h"
#include "LtsTrans.h"
using namespace magic;

/*********************************************************************/
//for creating a complete transition
/*********************************************************************/
LtsTrans::LtsTrans(const string &i,const string &f,const Action &a)
{
  initState = i;
  finalState = f;
  action = a;
}

/*********************************************************************/
//for creating a transition without initial state
/*********************************************************************/
LtsTrans::LtsTrans(const string &f,const Action &a)
{
  finalState = f;
  action = a;
}

/*********************************************************************/
//for creating a transition without initial state or final state
/*********************************************************************/
LtsTrans::LtsTrans(const Action &a) 
{
  action = a;
}

/*********************************************************************/
//operators
/*********************************************************************/
const LtsTrans &LtsTrans::operator = (const LtsTrans &rhs) 
{
  initState = rhs.initState;
  finalState = rhs.finalState;
  action = rhs.action;
  return *this;
}

bool LtsTrans::operator == (const LtsTrans &rhs) const
{
  return ((initState == rhs.initState) && 
	  (finalState == rhs.finalState) && (action == rhs.action));
}

//for the less than operator we first compare the initial states, then
//the final states and finally the actions
bool LtsTrans::operator < (const LtsTrans &rhs) const
{
  if(initState < rhs.initState) return true;
  else if(initState > rhs.initState) return false;
  else if(finalState < rhs.finalState) return true;
  else if(finalState > rhs.finalState) return false;
  else return (action < rhs.action);
}

/*********************************************************************/
//convert to string
/*********************************************************************/
string LtsTrans::ToString() const
{
  return initState + " -> " + action.ToString() + " -> " + finalState;
}

/*********************************************************************/
//end of LtsTrans.cpp
/*********************************************************************/
