/**************************** CPPHeaderFile ***************************

* FileName [FspInfo.h]

* PackageName [parser]

* Synopsis [Header file for FspInfo class.]

* Description [This class encapsulates all the info about
* specification FSPs provided through specification files. This is
* nothing but a set of transitions and alphabet extensions.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __FSPINFO_H__
#define __FSPINFO_H__

namespace magic {

//other classes needed
class LtsTrans;
class LtsInfo;

class FspInfo
{
 private:
  //the set of transitions
  set<LtsTrans> trans;

  //the map from process names to extended alphabets
  map< string,set<Action> > extAct;

 public:
  FspInfo();
  FspInfo(const FspInfo &rhs) { *this = rhs; }
  ~FspInfo() {}
  const FspInfo &operator = (const FspInfo &rhs) {
    trans = rhs.trans;
    return *this;
  }

  //add a transition
  void AddTrans(const LtsTrans &t);

  //add an alphabet extension
  void AddExtAct(const string &n,const set<Action> &a);

  //create info about LTS with given name
  LtsInfo GetLtsInfo(const string &name) const;

  //create info about the negation of named specification LTS
  LtsInfo GetSpecLtsNeg(const string &name);
};

} //namespace magic

#endif //__FSPINFO_H__

/*********************************************************************/
//end of FspInfo.h
/*********************************************************************/
