/**************************** CPPHeaderFile ***************************

* FileName [DFSAdapter.h]

* PackageName [parser]

* Synopsis [Header file for DFSAdapter class.]

* Description [This class encapsulates a depth-first AST walker.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __DFSADAPTER_H__
#define __DFSADAPTER_H__

namespace magic {

class DFSAdapter
{
 public:
  virtual void inExprList(const ExprList &node) {}
  virtual void outExprList(const ExprList &node) {}
  virtual void caseExprList(const ExprList &node);

  virtual void inIdExpr(const IdExpr &node) {}
  virtual void outIdExpr(const IdExpr &node) {}
  virtual void caseIdExpr(const IdExpr &node) {
    inIdExpr(node);
    outIdExpr(node);
  }

  virtual void inIntConstExpr(const IntConstExpr &node) {}
  virtual void outIntConstExpr(const IntConstExpr &node) {}
  virtual void caseIntConstExpr(const IntConstExpr &node) {
    inIntConstExpr(node);
    outIntConstExpr(node);
  }
  
  virtual void inConstExpr(const ConstExpr &node) {}
  virtual void outConstExpr(const ConstExpr &node) {}
  virtual void caseConstExpr(const ConstExpr &node) {
    inConstExpr(node);
    outConstExpr(node);
  }
  
  virtual void inStrExpr(const StrExpr &node) {}
  virtual void outStrExpr(const StrExpr &node) {}
  virtual void caseStrExpr(const StrExpr &node) {
    inStrExpr(node);
    outStrExpr(node);
  }
  
  virtual void inStrStrExpr(const StrStrExpr &node) {}
  virtual void outStrStrExpr(const StrStrExpr &node) {}
  virtual void caseStrStrExpr(const StrStrExpr &node) {
    inStrStrExpr(node);
    outStrStrExpr(node);
  }
  
  virtual void inStmtExpr(const StmtExpr &node) {}
  virtual void outStmtExpr(const StmtExpr &node) {}
  virtual void caseStmtExpr(const StmtExpr &node);

  virtual void inBrackExpr(const BrackExpr &node) {}
  virtual void outBrackExpr(const BrackExpr &node) {}
  virtual void caseBrackExpr(const BrackExpr &node);

  virtual void inParExpr(const ParExpr &node) {}
  virtual void outParExpr(const ParExpr &node) {}
  virtual void caseParExpr(const ParExpr &node);

  virtual void inDotExpr(const DotExpr &node) {}
  virtual void outDotExpr(const DotExpr &node) {}
  virtual void caseDotExpr(const DotExpr &node);

  virtual void inArrowExpr(const ArrowExpr &node) {}
  virtual void outArrowExpr(const ArrowExpr &node) {}
  virtual void caseArrowExpr(const ArrowExpr &node);

  virtual void inIncExpr(const IncExpr &node) {}
  virtual void outIncExpr(const IncExpr &node) {}
  virtual void caseIncExpr(const IncExpr &node);

  virtual void inUnaryExpr(const UnaryExpr &node) {}
  virtual void outUnaryExpr(const UnaryExpr &node) {}
  virtual void caseUnaryExpr(const UnaryExpr &node);

  virtual void inEmptyExpr(const EmptyExpr &node) {}
  virtual void outEmptyExpr(const EmptyExpr &node) {}
  virtual void caseEmptyExpr(const EmptyExpr &node) {
    inEmptyExpr(node);
    outEmptyExpr(node);
  }

  virtual void inBinaryExpr(const BinaryExpr &node) {}
  virtual void outBinaryExpr(const BinaryExpr &node) {}
  virtual void caseBinaryExpr(const BinaryExpr &node);

  virtual void inQuestExpr(const QuestExpr &node) {}
  virtual void outQuestExpr(const QuestExpr &node) {}
  virtual void caseQuestExpr(const QuestExpr &node);

  virtual void inAssignExpr(const AssignExpr &node) {}
  virtual void outAssignExpr(const AssignExpr &node) {}
  virtual void caseAssignExpr(const AssignExpr &node);
  

  virtual void inStmtList(const StmtList &node) {}
  virtual void outStmtList(const StmtList &node) {}
  virtual void caseStmtList(const StmtList &node);

  virtual void inLabelStmt(const LabelStmt &node) {}
  virtual void outLabelStmt(const LabelStmt &node) {}
  virtual void caseLabelStmt(const LabelStmt &node);

  virtual void inCaseStmt(const CaseStmt &node) {}
  virtual void outCaseStmt(const CaseStmt &node) {}
  virtual void caseCaseStmt(const CaseStmt &node);

  virtual void inDefaultStmt(const DefaultStmt &node) {}
  virtual void outDefaultStmt(const DefaultStmt &node) {}
  virtual void caseDefaultStmt(const DefaultStmt &node);

  virtual void inCompStmt(const CompStmt &node) {}
  virtual void outCompStmt(const CompStmt &node) {}
  virtual void caseCompStmt(const CompStmt &node);

  virtual void inExprStmt(const ExprStmt &node) {}
  virtual void outExprStmt(const ExprStmt &node) {}
  virtual void caseExprStmt(const ExprStmt &node);

  virtual void inEmptyStmt(const EmptyStmt &node) {}
  virtual void outEmptyStmt(const EmptyStmt &node) {}
  virtual void caseEmptyStmt(const EmptyStmt &node) {
    inEmptyStmt(node);
    outEmptyStmt(node);
  }

  virtual void inIfStmt(const IfStmt &node) {}
  virtual void outIfStmt(const IfStmt &node) {}
  virtual void caseIfStmt(const IfStmt &node);

  virtual void inSwitchStmt(const SwitchStmt &node) {}
  virtual void outSwitchStmt(const SwitchStmt &node) {}
  virtual void caseSwitchStmt(const SwitchStmt &node);

  virtual void inWhileStmt(const WhileStmt &node) {}
  virtual void outWhileStmt(const WhileStmt &node) {}
  virtual void caseWhileStmt(const WhileStmt &node);

  virtual void inDoStmt(const DoStmt &node) {}
  virtual void outDoStmt(const DoStmt &node) {}
  virtual void caseDoStmt(const DoStmt &node);

  virtual void inForStmt(const ForStmt &node) {}
  virtual void outForStmt(const ForStmt &node) {}
  virtual void caseForStmt(const ForStmt &node);

  virtual void inGotoStmt(const GotoStmt &node) {}
  virtual void outGotoStmt(const GotoStmt &node) {}
  virtual void caseGotoStmt(const GotoStmt &node) {
    inGotoStmt(node);
    outGotoStmt(node);
  }

  virtual void inContinueStmt(const ContinueStmt &node) {}
  virtual void outContinueStmt(const ContinueStmt &node) {}
  virtual void caseContinueStmt(const ContinueStmt &node) {
    inContinueStmt(node);
    outContinueStmt(node);
  }

  virtual void inBreakStmt(const BreakStmt &node) {}
  virtual void outBreakStmt(const BreakStmt &node) {}
  virtual void caseBreakStmt(const BreakStmt &node) {
    inBreakStmt(node);
    outBreakStmt(node);
  }

  virtual void inReturnStmt(const ReturnStmt &node) {}
  virtual void outReturnStmt(const ReturnStmt &node) {}
  virtual void caseReturnStmt(const ReturnStmt &node);

  virtual void inDecl(const Decl &node) {}
  virtual void outDecl(const Decl &node) {}
  virtual void caseDecl(const Decl &node) {
    inDecl(node);
    outDecl(node);
  }

  virtual void inProc(const Proc &node) {}
  virtual void outProc(const Proc &node) {}
  virtual void caseProc(const Proc &node);

  virtual void inStdcFile(const StdcFile &node) {}
  virtual void outStdcFile(const StdcFile &node) {}
  virtual void caseStdcFile(const StdcFile &node);
};

} //namespace magic

#endif //__DFSADAPTER_H__

/*********************************************************************/
//end of DFSAdapter.h
/*********************************************************************/
