/******************************** CPPFile *****************************

* FileName [DFSAdapter.cpp]

* PackageName [parser]

* Synopsis [Method definitions of DFSAdapter class.]

* SeeAlso [DFSAdapter.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cstdio>
#include <cassert>
#include <string>
#include <set>
#include <list>
#include <map>
using namespace std;

#include "Node.h"
#include "DFSAdapter.h"
using namespace magic;

void DFSAdapter::caseExprList(const ExprList &node)
{
  inExprList(node);
  for(list<BasicExpr*>::const_iterator i = node.data.begin();i != node.data.end();++i) {
    (*i)->Apply(*this);
  }
  outExprList(node);
}

void DFSAdapter::caseStmtExpr(const StmtExpr &node)
{
  inStmtExpr(node);
  node.stmt->Apply(*this);
  outStmtExpr(node);
}

void DFSAdapter::caseBrackExpr(const BrackExpr &node)
{
  inBrackExpr(node);
  node.array->Apply(*this);
  node.index->Apply(*this);
  outBrackExpr(node);
}

void DFSAdapter::caseParExpr(const ParExpr &node)
{
  inParExpr(node);
  node.proc->Apply(*this);
  node.args->Apply(*this);
  outParExpr(node);
}

void DFSAdapter::caseDotExpr(const DotExpr &node)
{
  inDotExpr(node);
  node.expr->Apply(*this);
  outDotExpr(node);
}

void DFSAdapter::caseArrowExpr(const ArrowExpr &node)
{
  inArrowExpr(node);
  node.expr->Apply(*this);
  outArrowExpr(node);
}

void DFSAdapter::caseIncExpr(const IncExpr &node)
{
  inIncExpr(node);
  node.expr->Apply(*this);
  outIncExpr(node);
}

void DFSAdapter::caseUnaryExpr(const UnaryExpr &node)
{
  inUnaryExpr(node);
  node.expr->Apply(*this);
  outUnaryExpr(node);
}

void DFSAdapter::caseBinaryExpr(const BinaryExpr &node)
{
  inBinaryExpr(node);
  node.lhs->Apply(*this);
  node.rhs->Apply(*this);
  outBinaryExpr(node);
}

void DFSAdapter::caseQuestExpr(const QuestExpr &node)
{
  inQuestExpr(node);
  node.cond->Apply(*this);
  node.tcase->Apply(*this);
  node.ecase->Apply(*this);
  outQuestExpr(node);
}

void DFSAdapter::caseAssignExpr(const AssignExpr &node)
{
  inAssignExpr(node);
  node.lhs->Apply(*this);
  node.rhs->Apply(*this);
  outAssignExpr(node);
}

void DFSAdapter::caseStmtList(const StmtList &node)
{
  inStmtList(node);
  for(list<Stmt*>::const_iterator i = node.data.begin();i != node.data.end();++i) {
    (*i)->Apply(*this);
  }
  outStmtList(node);
}

void DFSAdapter::caseLabelStmt(const LabelStmt &node)
{
  inLabelStmt(node);
  node.stmt->Apply(*this);
  outLabelStmt(node);
}

void DFSAdapter::caseCaseStmt(const CaseStmt &node)
{
  inCaseStmt(node);
  node.expr->Apply(*this);
  node.stmt->Apply(*this);
  outCaseStmt(node);
}

void DFSAdapter::caseDefaultStmt(const DefaultStmt &node)
{
  inDefaultStmt(node);
  node.stmt->Apply(*this);
  outDefaultStmt(node);
}

void DFSAdapter::caseCompStmt(const CompStmt &node)
{
  inCompStmt(node);
  node.data->Apply(*this);
  outCompStmt(node);
}

void DFSAdapter::caseExprStmt(const ExprStmt &node)
{
  inExprStmt(node);
  node.expr->Apply(*this);
  outExprStmt(node);
}

void DFSAdapter::caseIfStmt(const IfStmt &node)
{
  inIfStmt(node);
  node.expr->Apply(*this);
  node.tstmt->Apply(*this);
  node.estmt->Apply(*this);
  outIfStmt(node);
}

void DFSAdapter::caseSwitchStmt(const SwitchStmt &node)
{
  inSwitchStmt(node);
  node.expr->Apply(*this);
  node.stmt->Apply(*this);
  outSwitchStmt(node);
}

void DFSAdapter::caseWhileStmt(const WhileStmt &node)
{
  inWhileStmt(node);
  node.expr->Apply(*this);
  node.stmt->Apply(*this);
  outWhileStmt(node);
}

void DFSAdapter::caseDoStmt(const DoStmt &node)
{
  inDoStmt(node);
  node.expr->Apply(*this);
  node.stmt->Apply(*this);
  outDoStmt(node);
}

void DFSAdapter::caseForStmt(const ForStmt &node)
{
  inForStmt(node);
  node.init->Apply(*this);
  node.cond->Apply(*this);
  node.update->Apply(*this);
  node.stmt->Apply(*this);
  outForStmt(node);
}

void DFSAdapter::caseReturnStmt(const ReturnStmt &node)
{
  inReturnStmt(node);
  node.expr->Apply(*this);
  outReturnStmt(node);
}

void DFSAdapter::caseProc(const Proc &node)
{
  inProc(node);
  node.body->Apply(*this);
  outProc(node);
}

void DFSAdapter::caseStdcFile(const StdcFile &node)
{
  inStdcFile(node);
  for(list<Proc*>::const_iterator i = node.procs.begin();i != node.procs.end();++i) {
    (*i)->Apply(*this);
  }
  outStdcFile(node);
}

/*********************************************************************/
//end of DFSAdapter.cpp
/*********************************************************************/
