/**************************** CPPHeaderFile ***************************

* FileName [CSymbolTable.h]

* PackageName [parser]

* Synopsis [Header file for CSymbolTable class.]

* Description [This class encapsulates a symbol table for keeping
* track of C typedef names. A symbol table is a stack, each element of
* which contains the typedef names for a scope of definition.]

* SeeAlso [CSymbolTable.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __CSYMBOLTABLE_H__
#define __CSYMBOLTABLE_H__

namespace magic {

//other classes needed
class StdcFile;

class CSymbolTable
{
 private:
  //the stack of scopes - this is implemented as a list
  static list< set<string> > scopes;
  
 public:
  //constants for file types
  static const int STDC_FILE;
  static const int SPEC_FILE;


  //the type of file being parsed - this should be set to STDC before
  //parsing a C file and to SPEC before parsing a specfication file
  static int fileType;

  //the root of the abstract syntax tree created after parsing a C
  //file
  static StdcFile *ast;

  //whether we are inside a typedef construct
  static bool inTypedef;

  //buffer string used as temporary storage
  static string buffer;

  //long long buffer used as temporary storage for integer constant
  //values
  static long long longbuf;

  //methods
  static void Initialise();
  static void PushScope() { scopes.push_back(set<string>()); }
  static void PopScope() { scopes.pop_back(); }
  static void AddTypeName(string n);
  static bool NameInScope(string n);
};

}

#endif //__CSYMBOLTABLE_H__

/*********************************************************************/
//end of CSymbolTable.h
/*********************************************************************/
