/******************************** CPPFile *****************************

* FileName [CSymbolTable.cpp]

* PackageName [parser]

* Synopsis [Method definitions of CSymbolTable class.]

* SeeAlso [CSymbolTable.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cstdio>
#include <cassert>
#include <string>
#include <list>
#include <set>
using namespace std;

#include "CSymbolTable.h"
using namespace magic;

/*********************************************************************/
//define static members
/*********************************************************************/
const int CSymbolTable::STDC_FILE = 7000;
const int CSymbolTable::SPEC_FILE = 7010;

list< set<string> > CSymbolTable::scopes;
int CSymbolTable::fileType;
StdcFile *CSymbolTable::ast;
bool CSymbolTable::inTypedef;
string CSymbolTable::buffer;
long long CSymbolTable::longbuf;
extern int lineNum;

/*********************************************************************/
//methods
/*********************************************************************/
void CSymbolTable::Initialise()
{
  lineNum = 1;
  scopes.clear();
  scopes.push_back(set<string>());
  ast = NULL;
  inTypedef = false;
}

void CSymbolTable::AddTypeName(string n)
{
  if(inTypedef) {
    set<string> &x = scopes.back();
    x.insert(n);
  }
}

bool CSymbolTable::NameInScope(string n)
{
  for(list< set<string> >::iterator i = scopes.begin();i != scopes.end();++i) {
    if(i->count(n) != 0) return true;
  }
  return false;
}

/*********************************************************************/
//end of CSymbolTable.cpp
/*********************************************************************/
