%{
#include <cstdio>
#include <cassert>
#include <typeinfo>
#include <string>
#include <set>
#include <list>
#include <map>
#include <vector>
#include <typeinfo>
using namespace std;

#include "Util.h"
#include "CSymbolTable.h"
#include "Node.h"
#include "Action.h"
#include "ActionManager.h"
#include "Alias.h"
#include "ProgAbs.h"
#include "ProgInfo.h"
#include "ProcAbs.h"
#include "ProcAddInfo.h"
#include "LtsTrans.h"
#include "FspInfo.h"
#include "LtlFormula.h"
#include "LtlManager.h"
#include "Seaw.h"
#include "SeawManager.h"
#include "Database.h"
using namespace magic;

extern char Backuptext[];
extern int backup_lineNum,backup_column;
void Backuperror(char *s);
int Backuplex();
__attribute__ ((noreturn)) void GlobalShutdown(int sig);

//the last value assigned to an enumerator constant
extern BasicExpr *lastEnumVal;

namespace magic {

//utility routines
extern BasicExpr *SimplifyExpr(BasicExpr *arg);
extern list<LtsTrans> * MakeTransList(FspTransSeq *seq,FspBody *body); 
extern Stmt *ForToWhile(Stmt *one,Stmt *two,BasicExpr *three,Stmt *body);

} //namespace magic
%}

%union {
  char cval;
  int ival;
  long long lval;
  bool bval;
  string *strptr;
  list<string> *strlistptr;
  magic::Node *nptr;
  magic::BasicExpr *eptr;
  magic::ExprList *elptr;
  magic::Action *aptr;
  set<magic::Action> *asptr;
}

%token BACKUP_IDENTIFIER BACKUP_INT_CONSTANT BACKUP_CONSTANT BACKUP_STRING_LITERAL 
%token BACKUP_SIZEOF BACKUP_PTR_OP BACKUP_INC_OP BACKUP_DEC_OP BACKUP_LEFT_OP 
%token BACKUP_RIGHT_OP BACKUP_LE_OP BACKUP_GE_OP BACKUP_EQ_OP BACKUP_NE_OP 
%token BACKUP_AND_OP BACKUP_OR_OP BACKUP_MUL_ASSIGN BACKUP_DIV_ASSIGN BACKUP_MOD_ASSIGN 
%token BACKUP_ADD_ASSIGN BACKUP_SUB_ASSIGN BACKUP_LEFT_ASSIGN BACKUP_RIGHT_ASSIGN 
%token BACKUP_AND_ASSIGN BACKUP_XOR_ASSIGN BACKUP_OR_ASSIGN BACKUP_TYPE_NAME

%token BACKUP_RETURN BACKUP_LOWER_ID BACKUP_UPPER_ID BACKUP_BANG_BANG BACKUP_DUMMY_VAR 

%token BACKUP_OPTIONS BACKUP_INPUT_FILES BACKUP_FILE_NAME
%token BACKUP_TRUE BACKUP_FALSE
%token BACKUP_ABSTRACTION_NAME BACKUP_SIM_REL_FILE BACKUP_PARSE_ONLY
%token BACKUP_PARSE_ECHO BACKUP_DISPLAY_STATISTICS
%token BACKUP_IMPL_TYPE BACKUP_IMPL_C BACKUP_IMPL_PACC
%token BACKUP_CONF_TYPE BACKUP_CONF_SIMUL BACKUP_CONF_REACH BACKUP_CONF_TRACE
%token BACKUP_CONF_LTL BACKUP_CONF_DLOCK BACKUP_CONF_SEAW
%token BACKUP_CONF_CHECK_MECHANISM BACKUP_CONF_CHECK_EXPLICIT
%token BACKUP_CONF_CHECK_SAT BACKUP_CONF_CHECK_LTSA
%token BACKUP_C_PARSER_TYPE BACKUP_C_PARSER_DEFAULT BACKUP_C_PARSER_CTOOL
%token BACKUP_THEOREM_PROVER_USED BACKUP_THEOREM_PROVER_SIMPLIFY BACKUP_THEOREM_PROVER_CPROVER
%token BACKUP_THEOREM_PROVER_CVC BACKUP_THEOREM_PROVER_ICS 
%token BACKUP_THEOREM_PROVER_SVC BACKUP_THEOREM_PROVER_CVCL
%token BACKUP_SAT_SOLVER_USED BACKUP_SAT_SOLVER_CHAFF BACKUP_SAT_SOLVER_SATO 
%token BACKUP_SAT_SOLVER_GRASP BACKUP_SAT_SOLVER_HORN_AI
%token BACKUP_PATTERN_MATCHER_USED BACKUP_PATTERN_MATCHER_NAIVE
%token BACKUP_IGNORE_POINTERS BACKUP_USE_SYNTACTIC_CHECKS BACKUP_THEOREM_PROVER_CACHE
%token BACKUP_THEOREM_PROVER_CACHE_SIZE BACKUP_USE_PAM BACKUP_PREDS_FROM_SPEC
%token BACKUP_INIT_SEEDS_FROM_SPEC BACKUP_PREDS_FROM_CE BACKUP_VERBOSITY_LEVEL
%token BACKUP_HANDLE_DATA_COMM

%token BACKUP_USE_LIVE_VARS
%token BACKUP_INLINE_LIBS
%token BACKUP_CHECK_INVALID_PTR_DEREF
%token BACKUP_CHECK_ASSERTION_FAILURE
%token BACKUP_START_ITER
%token BACKUP_END_ITER
%token BACKUP_USE_REACH_IMPL
%token BACKUP_PRECOMPUTE_IMPL_TRANS
%token BACKUP_CACHE_IMPL_TRANS
%token BACKUP_SIM_REL_FROM_SAT
%token BACKUP_PREOPTIMIZE
%token BACKUP_PREOPTVISIT
%token BACKUP_PREOPTVISITS
%token BACKUP_PREOPTMINDEPTH
%token BACKUP_PREOPTMINCES
%token BACKUP_PREOPTMAXDEPTH
%token BACKUP_PREOPTMAXCES
%token BACKUP_COVERAGE
%token BACKUP_COVERCONT
%token BACKUP_SHOWCOVER
%token BACKUP_CEGAR

%token BACKUP_CEGAR_TYPE BACKUP_CEGAR_ELIMINATE_PRED BACKUP_CEGAR_USEFUL_PRED
%token BACKUP_CEGAR_OPTIMIZE_PRED BACKUP_CEGAR_GREEDY_PRED

%token BACKUP_INC_VERIFY
%token BACKUP_MAX_ADD_PRED
%token BACKUP_CHECK_CE_BRANCHING
%token BACKUP_PATH_CHECK_TYPE BACKUP_PATH_CHECK_FORWARD BACKUP_PATH_CHECK_BACKWARD
%token BACKUP_CE_DISPLAY_TYPE BACKUP_CE_LOC_ONLY BACKUP_CE_LOC_ACT
%token BACKUP_CE_LOC_CONS BACKUP_CE_LOC_CONS_ACT
%token BACKUP_CHECK_CE_VALIDITY
%token BACKUP_USE_PATTERN_MATCHER
%token BACKUP_MAX_GLOBAL_CE
%token BACKUP_MAX_CE_LOOP
%token BACKUP_CE_NEW_NODE_PROB
%token BACKUP_CNF_NO_NEW_VARS
%token BACKUP_LARGEST_SUBSET
%token BACKUP_SMALLEST_SUBSET
%token BACKUP_SUBSET_CUTOFF
%token BACKUP_CONSTRAINT_CUTOFF
%token BACKUP_STOP_OPT_AFTER_ELIM
%token BACKUP_USE_PRED_ABSTRACTION
%token BACKUP_USE_LTS_ABSTRACTION
%token BACKUP_NO_USELESS_LOCS
%token BACKUP_NO_SILENT_TRANS
%token BACKUP_MAX_PRED_INFER_LOOP
%token BACKUP_MAX_TIME_LIMIT
%token BACKUP_LTL_TO_BUCHI
%token BACKUP_CREATE_DOT_FILE
%token BACKUP_DRAW_LTS
%token BACKUP_DRAW_CFG
%token BACKUP_DRAW_INFERRED_PREDS
%token BACKUP_DRAW_PRED_ABS_LTS
%token BACKUP_DRAW_LTS_ABS_LTS
%token BACKUP_DRAW_COMPOSED_LTS
%token BACKUP_DRAW_CE_DAG
%token BACKUP_DRAW_CE_PROJ_LTS
%token BACKUP_DRAW_CE_PROJ_PRED
%token BACKUP_OUTPUT_MODELS

%token BACKUP_OUTPUT_MODEL_TYPE BACKUP_OUTPUT_MODEL_FSP

%token BACKUP_EXPLAIN_CE
%token BACKUP_ADDITIONAL_UNWIND
%token BACKUP_MAX_UNWIND
%token BACKUP_MORE_UNWIND
%token BACKUP_SPURIOUS_TRIES
%token BACKUP_ACTION_WEIGHT
%token BACKUP_PRED_WEIGHT
%token BACKUP_LTL_NEG

%type <lval> int_constant
%type <strptr> identifier constant string_literal
%type <bval> truth_value

%type <eptr> primary_expression postfix_expression
%type <elptr> argument_expression_list
%type <eptr> unary_expression
%type <cval> unary_operator
%type <eptr> cast_expression multiplicative_expression additive_expression
%type <eptr> shift_expression relational_expression equality_expression
%type <eptr> and_expression exclusive_or_expression inclusive_or_expression
%type <eptr> logical_and_expression logical_or_expression conditional_expression
%type <eptr> assignment_expression expression
%type <ival> assignment_operator

%type <strptr> lower_id upper_id dummy_var file_name
%type <elptr> predicate_list
%type <aptr> action_label
%type <nptr> translation_unit

%start translation_unit

%%

/*********************************************************************/
//basics
/*********************************************************************/

identifier 
         : BACKUP_IDENTIFIER { $$ = new string(CSymbolTable::buffer); } 
         | lower_id { $$ = $1; }
         | upper_id { $$ = $1; } 
         | dummy_var  { $$ = $1; }
         ;

int_constant : BACKUP_INT_CONSTANT { $$ = CSymbolTable::longbuf; } ;

constant : BACKUP_CONSTANT { $$ = new string(CSymbolTable::buffer); } ;

string_literal : BACKUP_STRING_LITERAL { $$ = new string(CSymbolTable::buffer); } ;

truth_value
         : BACKUP_TRUE { $$ = true; } 
         | BACKUP_FALSE { $$ = false; } 
         ;

lower_id : BACKUP_LOWER_ID { $$ = new string(CSymbolTable::buffer); } ;

upper_id : BACKUP_UPPER_ID { $$ = new string(CSymbolTable::buffer); } ;

dummy_var : BACKUP_DUMMY_VAR { $$ = new string(CSymbolTable::buffer); } ;

file_name
        : identifier { $$ = $1; }
        | BACKUP_FILE_NAME { $$ = new string(CSymbolTable::buffer); } 
        ;

/*********************************************************************/
//expressions
/*********************************************************************/

primary_expression
        : identifier { assert($1 != NULL); $$ = new IdExpr(*$1); delete $1; }
        | int_constant { $$ = new IntConstExpr($1); }
        | constant { assert($1 != NULL); $$ = new ConstExpr(*$1); delete $1; }
        | string_literal { assert($1 != NULL); $$ = new StrExpr(*$1); delete $1; }
        /* this is needed for calls like printk("<1>" "hello\n") */
        | string_literal string_literal {
	  assert(($1 != NULL) && ($2 != NULL)); 
	  $$ = new StrStrExpr(*$1,*$2);
	  delete $1;
	  delete $2;
	}
        | '(' expression ')' { $$ = $2; }
	;

postfix_expression
        : primary_expression { $$ = $1; }
        | postfix_expression '[' expression ']' {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BrackExpr($1,$3); 
	  delete $1; delete $3;
	}
        | postfix_expression '(' ')' {
	  assert($1 != NULL);
	  ExprList *x = new ExprList();
	  $$ = new ParExpr($1,x);
	  delete x; delete $1;
	}
	| postfix_expression '(' argument_expression_list ')' {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new ParExpr($1,$3);
	  delete $1; delete $3;
	}
        | postfix_expression '.' identifier {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new DotExpr($1,*$3);
	  delete $1; delete $3;
	}
        | postfix_expression BACKUP_PTR_OP identifier {
	  assert(($1 != NULL) && ($3 != NULL));
	  /* convert (&A)->B to A.B */
	  if(typeid(*$1) == typeid(UnaryExpr)) {
	    UnaryExpr *x = static_cast<UnaryExpr*>($1);
	    if(x->GetOp() == '&') {
	      $$ = new DotExpr(x->GetExpr(),*$3);
	    } else {
	      $$ = new ArrowExpr($1,*$3);
	    }
	  } else {
	    $$ = new ArrowExpr($1,*$3);
	  }
	  delete $1; delete $3;
	}
	| postfix_expression BACKUP_INC_OP {
	  assert($1 != NULL);
	  $$ = new IncExpr($1,Database::POST_INC);
	  delete $1;
	}
	| postfix_expression BACKUP_DEC_OP {
	  assert($1 != NULL);
	  $$ = new IncExpr($1,Database::POST_DEC);
	  delete $1;
	}
	;

argument_expression_list
	: assignment_expression { 
	  assert($1 != NULL);
	  $$ = new ExprList();
	  $$->AddExpr($1); 
	  delete $1; 
        }
	| argument_expression_list ',' assignment_expression { 
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = $1;
	  $$->AddExpr($3); 
	  delete $3; 
	}
	;

unary_expression
        : postfix_expression { $$ = $1; }
	| BACKUP_INC_OP unary_expression {
	  assert($2 != NULL);
	  $$ = new IncExpr($2,Database::PRE_INC);
	  delete $2;
	}
	| BACKUP_DEC_OP unary_expression {
	  assert($2 != NULL);
	  $$ = new IncExpr($2,Database::PRE_DEC);
	  delete $2;
	}
        | unary_operator cast_expression {
	  assert($2 != NULL);
	  /* reduce *&A and &*A to A */
	  if(typeid(*$2) == typeid(UnaryExpr)) {
	    UnaryExpr *x = static_cast<UnaryExpr*>($2);
	    if((($1 == '*') && (x->GetOp() == '&')) || (($1 == '&') && (x->GetOp() == '*'))) {
	      $$ = static_cast<BasicExpr*>(x->GetExpr()->Clone());
	    } else {
	      $$ = new UnaryExpr($2,$1);
	      $$ = SimplifyExpr($$);
	    }
	  } else {
	    $$ = new UnaryExpr($2,$1);
	    $$ = SimplifyExpr($$);
	  }
	  delete $2;
	}
	| BACKUP_SIZEOF unary_expression { 
	  $$ = $2;
	}
	;

unary_operator
	: '&' { $$ = '&'; }
	| '*' { $$ = '*'; }
	| '+' { $$ = '+'; }
	| '-' { $$ = '-'; }
	| '~' { $$ = '~'; }
	| '!' { $$ = '!'; }
	;

cast_expression
	: unary_expression { $$ = $1; }
	;

multiplicative_expression
	: cast_expression { $$ = $1; }
	| multiplicative_expression '*' cast_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'*');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	| multiplicative_expression '/' cast_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'/');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	| multiplicative_expression '%' cast_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'%');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

additive_expression
	: multiplicative_expression { $$ = $1; }
	| additive_expression '+' multiplicative_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'+');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
        | additive_expression '-' multiplicative_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'-');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

shift_expression
        : additive_expression { $$ = $1; }
        | shift_expression BACKUP_LEFT_OP additive_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_LEFT_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
        | shift_expression BACKUP_RIGHT_OP additive_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_RIGHT_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

relational_expression
        : shift_expression { $$ = $1; }
	| relational_expression '<' shift_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'<');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	| relational_expression '>' shift_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'>');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	| relational_expression BACKUP_LE_OP shift_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_LE_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	| relational_expression BACKUP_GE_OP shift_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_GE_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

equality_expression
        : relational_expression {}
	| equality_expression BACKUP_EQ_OP relational_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_EQ_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	| equality_expression BACKUP_NE_OP relational_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_NE_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

and_expression
	: equality_expression { $$ = $1; }
	| and_expression '&' equality_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'&');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

exclusive_or_expression
	: and_expression { $$ = $1; }
	| exclusive_or_expression '^' and_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'^');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

inclusive_or_expression
	: exclusive_or_expression { $$ = $1; }
	| inclusive_or_expression '|' exclusive_or_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,'|');
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

logical_and_expression
	: inclusive_or_expression { $$ = $1; }
	| logical_and_expression BACKUP_AND_OP inclusive_or_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_AND_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

logical_or_expression
	: logical_and_expression { $$ = $1; }
	| logical_or_expression BACKUP_OR_OP logical_and_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,BACKUP_OR_OP);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3;
	}
	;

conditional_expression
	: logical_or_expression { $$ = $1; }
	| logical_or_expression '?' ':' conditional_expression {
	  assert(($1 != NULL) && ($4 != NULL));
	  $$ = new QuestExpr($1,$1,$4);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $4;
	}
	| logical_or_expression '?' expression ':' conditional_expression {
	  assert(($1 != NULL) && ($3 != NULL) && ($5 != NULL));
	  $$ = new QuestExpr($1,$3,$5);
	  $$ = SimplifyExpr($$);
	  delete $1; delete $3; delete $5;
	}
	;

assignment_expression
        : conditional_expression { $$ = $1; }
	| unary_expression assignment_operator assignment_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  BasicExpr *rhs = NULL;
	  if($2 == '=') rhs = static_cast<BasicExpr*>($3->Clone());
	  else if($2 == BACKUP_MUL_ASSIGN) rhs = new BinaryExpr($1,$3,'*');
	  else if($2 == BACKUP_DIV_ASSIGN) rhs = new BinaryExpr($1,$3,'/');
	  else if($2 == BACKUP_MOD_ASSIGN) rhs = new BinaryExpr($1,$3,'%');
	  else if($2 == BACKUP_ADD_ASSIGN) rhs = new BinaryExpr($1,$3,'+');
	  else if($2 == BACKUP_SUB_ASSIGN) rhs = new BinaryExpr($1,$3,'-');
	  else if($2 == BACKUP_LEFT_ASSIGN) rhs = new BinaryExpr($1,$3,BACKUP_LEFT_OP);
	  else if($2 == BACKUP_RIGHT_ASSIGN) rhs = new BinaryExpr($1,$3,BACKUP_RIGHT_OP);
	  else if($2 == BACKUP_AND_ASSIGN) rhs = new BinaryExpr($1,$3,'&');
	  else if($2 == BACKUP_XOR_ASSIGN) rhs = new BinaryExpr($1,$3,'^');
	  else if($2 == BACKUP_OR_ASSIGN) rhs = new BinaryExpr($1,$3,'|');
	  else assert(false);
	  $$ = new AssignExpr($1,rhs);
	  delete rhs; delete $1; delete $3;
	}
	;

assignment_operator
	: '=' { $$ = '='; }
	| BACKUP_MUL_ASSIGN { $$ = BACKUP_MUL_ASSIGN; }
	| BACKUP_DIV_ASSIGN { $$ = BACKUP_DIV_ASSIGN; }
	| BACKUP_MOD_ASSIGN { $$ = BACKUP_MOD_ASSIGN; }
	| BACKUP_ADD_ASSIGN { $$ = BACKUP_ADD_ASSIGN; }
	| BACKUP_SUB_ASSIGN { $$ = BACKUP_SUB_ASSIGN; }
	| BACKUP_LEFT_ASSIGN { $$ = BACKUP_LEFT_ASSIGN; }
	| BACKUP_RIGHT_ASSIGN { $$ = BACKUP_RIGHT_ASSIGN; }
	| BACKUP_AND_ASSIGN { $$ = BACKUP_AND_ASSIGN; }
	| BACKUP_XOR_ASSIGN { $$ = BACKUP_XOR_ASSIGN; }
	| BACKUP_OR_ASSIGN { $$ = BACKUP_OR_ASSIGN; }
	;

expression
        : assignment_expression { $$ = $1; }
        | expression ',' assignment_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = new BinaryExpr($1,$3,',');
	  delete $1; delete $3;
	}
	;

/*********************************************************************/
//begin backup productions
/*********************************************************************/

action_label
        /*id*/
	: lower_id {
          assert($1 != NULL);
	  $$ = new Action(*$1);
	  delete $1;
        }
        /*normal return*/
	| BACKUP_RETURN '{' conditional_expression '}' {
	  assert($3 != NULL);
	  $$ = new Action($3);
	  delete $3;
	}
        /*void return*/
	| BACKUP_RETURN '{' '}' {
	  BasicExpr *x = new EmptyExpr();
	  $$ = new Action(x);
	  delete x;
	}
        /*assign*/
        | '{' conditional_expression  '=' '[' conditional_expression ']' '}' {
	  assert(($2 != NULL) && ($5 != NULL));
	  $$ = new Action($2,$5);
	  delete $2; delete $5;
	}
        /*broadcast*/
        | lower_id BACKUP_BANG_BANG '[' predicate_list ']' {
	  assert(($1 != NULL) && ($4 != NULL));
	  $$ = new Action(BasicAction::ACTION_BCAST,*$1,*$4);
	  delete $1; delete $4;
	}
        /*void send*/
        | lower_id '!' '[' ']' {
	  assert($1 != NULL);
	  $$ = new Action(BasicAction::ACTION_SEND,*$1,list<Expr>());
	  delete $1;
	}
        /*send*/
        | lower_id '!' '[' predicate_list ']' {
	  assert(($1 != NULL) && ($4 != NULL));
	  $$ = new Action(BasicAction::ACTION_SEND,*$1,*$4);
	  delete $1; delete $4;
	}
        /*void receive*/
        | lower_id '?' '[' ']' {
	  assert($1 != NULL);
	  $$ = new Action(BasicAction::ACTION_RECV,*$1,list<Expr>());
	  delete $1;
	}
        /*receive*/
        | lower_id '?' '[' predicate_list ']' {
	  assert(($1 != NULL) && ($4 != NULL));
	  $$ = new Action(BasicAction::ACTION_RECV,*$1,*$4);
	  delete $1; delete $4;
	}
        ;

predicate_list
        /*pred*/
        : conditional_expression {
          assert($1 != NULL);
	  $$ = new ExprList();
	  $$->AddExpr($1);
	  delete $1;
        }
        /*list*/
	| predicate_list ',' conditional_expression {
	  assert(($1 != NULL) && ($3 != NULL));
	  $$ = $1;
	  $$->AddExpr($3);
	  delete $3;
	}
        ;


/*********************************************************************/
//rules options
/*********************************************************************/

option 
        : BACKUP_ABSTRACTION_NAME '=' identifier {
          assert($3 != NULL);
	  Database::ABSTRACTION_NAME = *$3;
	  delete $3;
        }
        | BACKUP_SIM_REL_FILE '=' file_name {
          assert($3 != NULL);
	  Database::SIM_REL_FILE = *$3;
	  delete $3;
        }
        | BACKUP_PARSE_ONLY '=' truth_value { Database::PARSE_ONLY = $3; }
        | BACKUP_PARSE_ECHO '=' truth_value { Database::PARSE_ECHO = $3; }
        | BACKUP_DISPLAY_STATISTICS '=' truth_value { Database::DISPLAY_STATISTICS = $3; }

        | BACKUP_IMPL_TYPE '=' BACKUP_IMPL_C { Database::IMPL_TYPE = Database::IMPL_C; }
        | BACKUP_IMPL_TYPE '=' BACKUP_IMPL_PACC { Database::IMPL_TYPE = Database::IMPL_PACC; }

        | BACKUP_CONF_TYPE '=' BACKUP_CONF_SIMUL { Database::CONF_TYPE = Database::CONF_SIMUL; }
        | BACKUP_CONF_TYPE '=' BACKUP_CONF_REACH { Database::CONF_TYPE = Database::CONF_REACH; }
        | BACKUP_CONF_TYPE '=' BACKUP_CONF_TRACE { Database::CONF_TYPE = Database::CONF_TRACE; }
        | BACKUP_CONF_TYPE '=' BACKUP_CONF_LTL { Database::CONF_TYPE = Database::CONF_LTL; }
        | BACKUP_CONF_TYPE '=' BACKUP_CONF_DLOCK { Database::CONF_TYPE = Database::CONF_DLOCK; }
        | BACKUP_CONF_TYPE '=' BACKUP_CONF_SEAW { Database::CONF_TYPE = Database::CONF_SEAW; }

        | BACKUP_CONF_CHECK_MECHANISM '=' BACKUP_CONF_CHECK_EXPLICIT { Database::CONF_CHECK_MECHANISM = Database::CONF_CHECK_EXPLICIT; }
        | BACKUP_CONF_CHECK_MECHANISM '=' BACKUP_CONF_CHECK_SAT { Database::CONF_CHECK_MECHANISM = Database::CONF_CHECK_SAT; }
        | BACKUP_CONF_CHECK_MECHANISM '=' BACKUP_CONF_CHECK_LTSA { Database::CONF_CHECK_MECHANISM = Database::CONF_CHECK_LTSA; }

        | BACKUP_C_PARSER_TYPE '=' BACKUP_C_PARSER_DEFAULT { Database::C_PARSER_TYPE = Database::C_PARSER_DEFAULT; }
        | BACKUP_C_PARSER_TYPE '=' BACKUP_C_PARSER_CTOOL { Database::C_PARSER_TYPE = Database::C_PARSER_CTOOL; }

        | BACKUP_THEOREM_PROVER_USED '=' BACKUP_THEOREM_PROVER_SIMPLIFY { Database::THEOREM_PROVER_USED = Database::THEOREM_PROVER_SIMPLIFY; }
        | BACKUP_THEOREM_PROVER_USED '=' BACKUP_THEOREM_PROVER_CPROVER { Database::THEOREM_PROVER_USED = Database::THEOREM_PROVER_CPROVER; }
        | BACKUP_THEOREM_PROVER_USED '=' BACKUP_THEOREM_PROVER_CVC { Database::THEOREM_PROVER_USED = Database::THEOREM_PROVER_CVC; }
        | BACKUP_THEOREM_PROVER_USED '=' BACKUP_THEOREM_PROVER_ICS { Database::THEOREM_PROVER_USED = Database::THEOREM_PROVER_ICS; }
        | BACKUP_THEOREM_PROVER_USED '=' BACKUP_THEOREM_PROVER_SVC { Database::THEOREM_PROVER_USED = Database::THEOREM_PROVER_SVC; }
        | BACKUP_THEOREM_PROVER_USED '=' BACKUP_THEOREM_PROVER_CVCL { Database::THEOREM_PROVER_USED = Database::THEOREM_PROVER_CVCL; }

        | BACKUP_SAT_SOLVER_USED '=' BACKUP_SAT_SOLVER_CHAFF { Database::SAT_SOLVER_USED = Database::SAT_SOLVER_CHAFF; }
        | BACKUP_SAT_SOLVER_USED '=' BACKUP_SAT_SOLVER_SATO { Database::SAT_SOLVER_USED = Database::SAT_SOLVER_SATO; }
        | BACKUP_SAT_SOLVER_USED '=' BACKUP_SAT_SOLVER_GRASP { Database::SAT_SOLVER_USED = Database::SAT_SOLVER_GRASP; }
        | BACKUP_SAT_SOLVER_USED '=' BACKUP_SAT_SOLVER_HORN_AI { Database::SAT_SOLVER_USED = Database::SAT_SOLVER_HORN_AI; }

        | BACKUP_PATTERN_MATCHER_USED '=' BACKUP_PATTERN_MATCHER_NAIVE { Database::PATTERN_MATCHER_USED = Database::PATTERN_MATCHER_NAIVE; }

        | BACKUP_IGNORE_POINTERS '=' truth_value { Database::IGNORE_POINTERS = $3; }
        | BACKUP_USE_SYNTACTIC_CHECKS '=' truth_value { Database::USE_SYNTACTIC_CHECKS = $3; }
        | BACKUP_THEOREM_PROVER_CACHE '=' truth_value { Database::THEOREM_PROVER_CACHE = $3; }
        | BACKUP_THEOREM_PROVER_CACHE_SIZE '=' int_constant { Database::THEOREM_PROVER_CACHE_SIZE = static_cast<int>($3); }
        | BACKUP_USE_PAM '=' truth_value { Database::USE_PAM = $3; }
        | BACKUP_PREDS_FROM_SPEC '=' truth_value { Database::PREDS_FROM_SPEC = $3; }
        | BACKUP_INIT_SEEDS_FROM_SPEC '=' truth_value { Database::INIT_SEEDS_FROM_SPEC = $3; }
        | BACKUP_PREDS_FROM_CE '=' truth_value { Database::PREDS_FROM_CE = $3; }
        | BACKUP_VERBOSITY_LEVEL '=' int_constant { Database::VERBOSITY_LEVEL = static_cast<int>($3); }
        | BACKUP_HANDLE_DATA_COMM '=' truth_value { Database::HANDLE_DATA_COMM = $3; }

        | BACKUP_USE_LIVE_VARS '=' truth_value { Database::USE_LIVE_VARS = $3; }
        | BACKUP_INLINE_LIBS '=' truth_value { Database::INLINE_LIBS = $3; }
        | BACKUP_CHECK_INVALID_PTR_DEREF '=' truth_value { Database::CHECK_INVALID_PTR_DEREF = $3; }
        | BACKUP_CHECK_ASSERTION_FAILURE '=' truth_value { Database::CHECK_ASSERTION_FAILURE = $3; }
        | BACKUP_START_ITER '=' int_constant { Database::START_ITER = static_cast<int>($3); }
        | BACKUP_END_ITER '=' int_constant { Database::END_ITER = static_cast<int>($3); }
        | BACKUP_USE_REACH_IMPL '=' truth_value { Database::USE_REACH_IMPL = $3; }
        | BACKUP_PRECOMPUTE_IMPL_TRANS '=' truth_value { Database::PRECOMPUTE_IMPL_TRANS = $3; }
        | BACKUP_CACHE_IMPL_TRANS '=' truth_value { Database::CACHE_IMPL_TRANS = $3; }
        | BACKUP_SIM_REL_FROM_SAT '=' truth_value { Database::SIM_REL_FROM_SAT = $3; }
        | BACKUP_PREOPTIMIZE '=' truth_value { Database::PREOPTIMIZE = $3; }
        | BACKUP_PREOPTVISIT '=' truth_value { Database::PREOPTVISIT = $3; }
        | BACKUP_PREOPTVISITS '=' int_constant { Database::PREOPTVISITS = static_cast<int>($3); }
        | BACKUP_PREOPTMINDEPTH '=' int_constant { Database::PREOPTMINDEPTH = static_cast<int>($3); }
        | BACKUP_PREOPTMINCES '=' int_constant { Database::PREOPTMINCES = static_cast<int>($3); }
        | BACKUP_PREOPTMAXDEPTH '=' int_constant { Database::PREOPTMAXDEPTH = static_cast<int>($3); }
        | BACKUP_PREOPTMAXCES '=' int_constant { Database::PREOPTMAXCES = static_cast<int>($3); }
        | BACKUP_COVERAGE '=' truth_value { Database::COVERAGE = $3; }
        | BACKUP_COVERCONT '=' truth_value { Database::COVERCONT = $3; }
        | BACKUP_SHOWCOVER '=' truth_value { Database::SHOWCOVER = $3; }
        | BACKUP_CEGAR '=' truth_value { Database::CEGAR = $3; }

        | BACKUP_CEGAR_TYPE '=' BACKUP_CEGAR_ELIMINATE_PRED { Database::CEGAR_TYPE = Database::CEGAR_ELIMINATE_PRED; }
        | BACKUP_CEGAR_TYPE '=' BACKUP_CEGAR_USEFUL_PRED { Database::CEGAR_TYPE = Database::CEGAR_USEFUL_PRED; }
        | BACKUP_CEGAR_TYPE '=' BACKUP_CEGAR_OPTIMIZE_PRED { Database::CEGAR_TYPE = Database::CEGAR_OPTIMIZE_PRED; }
        | BACKUP_CEGAR_TYPE '=' BACKUP_CEGAR_GREEDY_PRED { Database::CEGAR_TYPE = Database::CEGAR_GREEDY_PRED; }

        | BACKUP_INC_VERIFY '=' truth_value { Database::INC_VERIFY = $3; }

        | BACKUP_PATH_CHECK_TYPE '=' BACKUP_PATH_CHECK_FORWARD { Database::PATH_CHECK_TYPE = Database::PATH_CHECK_FORWARD; }
        | BACKUP_PATH_CHECK_TYPE '=' BACKUP_PATH_CHECK_BACKWARD { Database::PATH_CHECK_TYPE = Database::PATH_CHECK_BACKWARD; }

        | BACKUP_CE_DISPLAY_TYPE '=' BACKUP_CE_LOC_ONLY { Database::CE_DISPLAY_TYPE = Database::CE_LOC_ONLY; }
        | BACKUP_CE_DISPLAY_TYPE '=' BACKUP_CE_LOC_ACT { Database::CE_DISPLAY_TYPE = Database::CE_LOC_ACT; }
        | BACKUP_CE_DISPLAY_TYPE '=' BACKUP_CE_LOC_CONS { Database::CE_DISPLAY_TYPE = Database::CE_LOC_CONS; }
        | BACKUP_CE_DISPLAY_TYPE '=' BACKUP_CE_LOC_CONS_ACT { Database::CE_DISPLAY_TYPE = Database::CE_LOC_CONS_ACT; }

        | BACKUP_MAX_ADD_PRED '=' int_constant { Database::MAX_ADD_PRED = static_cast<int>($3); }
        | BACKUP_CHECK_CE_BRANCHING '=' truth_value { Database::CHECK_CE_BRANCHING = $3; }
        | BACKUP_CHECK_CE_VALIDITY '=' truth_value { Database::CHECK_CE_VALIDITY = $3; }
        | BACKUP_USE_PATTERN_MATCHER '=' truth_value { Database::USE_PATTERN_MATCHER = $3; }
        | BACKUP_MAX_GLOBAL_CE '=' int_constant { Database::MAX_GLOBAL_CE = static_cast<int>($3); }
        | BACKUP_MAX_CE_LOOP '=' int_constant { Database::MAX_CE_LOOP = static_cast<int>($3); }
        | BACKUP_CNF_NO_NEW_VARS '=' truth_value { Database::CNF_NO_NEW_VARS = $3; }
        | BACKUP_LARGEST_SUBSET '=' int_constant { Database::LARGEST_SUBSET = static_cast<int>($3); }
        | BACKUP_SMALLEST_SUBSET '=' int_constant { Database::SMALLEST_SUBSET = static_cast<int>($3); }
        | BACKUP_SUBSET_CUTOFF '=' int_constant { Database::SUBSET_CUTOFF = static_cast<int>($3); }
        | BACKUP_CONSTRAINT_CUTOFF '=' int_constant { Database::CONSTRAINT_CUTOFF = static_cast<int>($3); }
        | BACKUP_STOP_OPT_AFTER_ELIM '=' truth_value { Database::STOP_OPT_AFTER_ELIM = $3; }
        | BACKUP_USE_PRED_ABSTRACTION '=' truth_value { Database::USE_PRED_ABSTRACTION = $3; }
        | BACKUP_USE_LTS_ABSTRACTION '=' truth_value { Database::USE_LTS_ABSTRACTION = $3; }
        | BACKUP_NO_USELESS_LOCS '=' truth_value { Database::NO_USELESS_LOCS = $3; }
        | BACKUP_NO_SILENT_TRANS '=' truth_value { Database::NO_SILENT_TRANS = $3; }
        | BACKUP_MAX_PRED_INFER_LOOP '=' int_constant { Database::MAX_PRED_INFER_LOOP = static_cast<int>($3); }
        | BACKUP_MAX_TIME_LIMIT '=' int_constant { Database::MAX_TIME_LIMIT = static_cast<int>($3); }
        | BACKUP_LTL_TO_BUCHI '=' truth_value { Database::LTL_TO_BUCHI = $3; }
        | BACKUP_CREATE_DOT_FILE '=' truth_value { Database::CREATE_DOT_FILE = $3; }
        | BACKUP_DRAW_LTS '=' truth_value { Database::DRAW_LTS = $3; }
        | BACKUP_DRAW_CFG '=' truth_value { Database::DRAW_CFG = $3; }
        | BACKUP_DRAW_INFERRED_PREDS '=' truth_value { Database::DRAW_INFERRED_PREDS = $3; }
        | BACKUP_DRAW_PRED_ABS_LTS '=' truth_value { Database::DRAW_PRED_ABS_LTS = $3; }
        | BACKUP_DRAW_LTS_ABS_LTS '=' truth_value { Database::DRAW_LTS_ABS_LTS = $3; }
        | BACKUP_DRAW_COMPOSED_LTS '=' truth_value { Database::DRAW_COMPOSED_LTS = $3; }
        | BACKUP_DRAW_CE_DAG '=' truth_value { Database::DRAW_CE_DAG = $3; }
        | BACKUP_DRAW_CE_PROJ_LTS '=' truth_value { Database::DRAW_CE_PROJ_LTS = $3; }
        | BACKUP_DRAW_CE_PROJ_PRED '=' truth_value { Database::DRAW_CE_PROJ_PRED = $3; }
        | BACKUP_OUTPUT_MODELS '=' truth_value { Database::OUTPUT_MODELS = $3; }

        | BACKUP_OUTPUT_MODEL_TYPE '=' BACKUP_OUTPUT_MODEL_FSP { Database::OUTPUT_MODEL_TYPE = Database::OUTPUT_MODEL_FSP; }

        | BACKUP_EXPLAIN_CE '=' truth_value { Database::EXPLAIN_CE = $3; }
        | BACKUP_ADDITIONAL_UNWIND '=' int_constant { Database::ADDITIONAL_UNWIND = static_cast<int>($3); }
        | BACKUP_MAX_UNWIND '=' int_constant { Database::MAX_UNWIND = static_cast<int>($3); }
        | BACKUP_MORE_UNWIND '=' truth_value { Database::MORE_UNWIND = $3; }
        | BACKUP_SPURIOUS_TRIES '=' int_constant { Database::SPURIOUS_TRIES = static_cast<int>($3); }
        | BACKUP_ACTION_WEIGHT '=' int_constant { Database::ACTION_WEIGHT = static_cast<int>($3); }
        | BACKUP_PRED_WEIGHT '=' int_constant { Database::PRED_WEIGHT = static_cast<int>($3); }
        | BACKUP_LTL_NEG '=' truth_value { Database::LTL_NEG = $3; }
        ;

option_list 
        : option {}
        | option_list option {}
        ;

options 
        : BACKUP_OPTIONS '{' '}' {}
        | BACKUP_OPTIONS '{' option_list '}' {} 
        ;

/*********************************************************************/
//rules for file names
/*********************************************************************/

file_name_list 
        : file_name {
	  assert($1 != NULL);
	  Database::FILE_NAMES.push_back(*$1);
	  delete $1;
        }
        | file_name_list  file_name {
	  assert($2 != NULL);
	  Database::FILE_NAMES.push_back(*$2);
	  delete $2;	  
	}
        ;

input_files
        : BACKUP_INPUT_FILES '{' '}' {}
        | BACKUP_INPUT_FILES '{' file_name_list '}' {} 
        ;

/*********************************************************************/
//the top-level rule
/*********************************************************************/

translation_unit : options input_files {} ;

%%

void Backuperror(char *s)
{
  fflush(stdout);
  if(Database::PARSE_ECHO) {
    Util::Message(2,"\n----------------------------------------------------------\n");
  }
  Util::Message(2,"ERROR: at line number %d column %d: %s ...\n",backup_lineNum,backup_column,s);
  if(!Database::PARSE_ECHO) {
    Util::Message(2,"try --echo for the token after which the error ocurred ...\n");
  }
  GlobalShutdown(-1);
}

/*********************************************************************/
//end of BackupParser.cpp
/*********************************************************************/
