D			[0-9]
L			[a-zA-Z_]
UL                      [A-Z_]
LL                      [a-z_]
H			[a-fA-F0-9]
E			[Ee][+-]?{D}+
FS			(f|F|l|L)
IS			(u|U|l|L)*

%{
#include <cstdio>
#include <cassert>
#include <string>
#include <set>
#include <list>
#include <map>
#include <vector>
using namespace std;

#include "CSymbolTable.h"
#include "Database.h"
#define YYSTYPE int
#include "BackupParser.h"
using namespace magic;

/*********************************************************************/
//global shutdown method defined in arc.cpp needed
/*********************************************************************/
__attribute__ ((noreturn)) void GlobalShutdown(int sig);

void backup_count(const char *message);

//counters
int backup_commentCount;
%}

%option noyywrap
%x BACKUP COMMENT

%%
         /* set the appropriate start condition */ 
         BEGIN(BACKUP);

<BACKUP,COMMENT>"/*" {
  if(YY_START == BACKUP) {
    BEGIN(COMMENT);
    backup_commentCount = 1;
  } else if(YY_START == COMMENT) ++backup_commentCount;
  else assert(false);
}
<COMMENT>"*/" {
  --backup_commentCount;
  if(backup_commentCount == 0) BEGIN(BACKUP);
}
<COMMENT>[^/*]*                                     { /* comment body - ignore */ }

<BACKUP>"//"(.*)                                    { /* CPP comment - ignore */ }

<BACKUP>"return"	   { backup_count("RETURN"); return(BACKUP_RETURN); }
<BACKUP>"sizeof"	   { backup_count("SIZEOF"); return(BACKUP_SIZEOF); }
<BACKUP>"options"	   { backup_count("OPTIONS"); return(BACKUP_OPTIONS); }
<BACKUP>"input_files"	   { backup_count("INPUT_FILES"); return(BACKUP_INPUT_FILES); }
<BACKUP>"true"		   { backup_count("TRUE"); return(BACKUP_TRUE); }
<BACKUP>"false"		   { backup_count("FALSE"); return(BACKUP_FALSE); }

 /* MAGIC options */
<BACKUP>"ABSTRACTION_NAME"         { backup_count("ABSTRACTION_NAME"); return(BACKUP_ABSTRACTION_NAME); }
<BACKUP>"SIM_REL_FILE"             { backup_count("SIM_REL_FILE"); return(BACKUP_SIM_REL_FILE); }
<BACKUP>"PARSE_ONLY"               { backup_count("PARSE_ONLY"); return(BACKUP_PARSE_ONLY); }
<BACKUP>"PARSE_ECHO"               { backup_count("PARSE_ECHO"); return(BACKUP_PARSE_ECHO); }
<BACKUP>"DISPLAY_STATISTICS"       { backup_count("DISPLAY_STATISTICS"); return(BACKUP_DISPLAY_STATISTICS); }

<BACKUP>"IMPL_TYPE"                { backup_count("IMPL_TYPE"); return(BACKUP_IMPL_TYPE); }
<BACKUP>"IMPL_C"                   { backup_count("IMPL_C"); return(BACKUP_IMPL_C); }
<BACKUP>"IMPL_PACC"                { backup_count("IMPL_PACC"); return(BACKUP_IMPL_PACC); }

<BACKUP>"CONF_TYPE"                { backup_count("CONF_TYPE"); return(BACKUP_CONF_TYPE); }
<BACKUP>"CONF_SIMUL"               { backup_count("CONF_SIMUL"); return(BACKUP_CONF_SIMUL); }
<BACKUP>"CONF_REACH"               { backup_count("CONF_REACH"); return(BACKUP_CONF_REACH); }
<BACKUP>"CONF_TRACE"               { backup_count("CONF_TRACE"); return(BACKUP_CONF_TRACE); }
<BACKUP>"CONF_LTL"                 { backup_count("CONF_LTL"); return(BACKUP_CONF_LTL); }
<BACKUP>"CONF_DLOCK"               { backup_count("CONF_DLOCK"); return(BACKUP_CONF_DLOCK); }
<BACKUP>"CONF_SEAW"                { backup_count("CONF_SEAW"); return(BACKUP_CONF_SEAW); }

<BACKUP>"CONF_CHECK_MECHANISM"     { backup_count("CONF_CHECK_MECHANISM"); return(BACKUP_CONF_CHECK_MECHANISM); }
<BACKUP>"CONF_CHECK_EXPLICIT"      { backup_count("CONF_CHECK_MECHANISM"); return(BACKUP_CONF_CHECK_EXPLICIT); }
<BACKUP>"CONF_CHECK_SAT"           { backup_count("CONF_CHECK_MECHANISM"); return(BACKUP_CONF_CHECK_SAT); }
<BACKUP>"CONF_CHECK_LTSA"          { backup_count("CONF_CHECK_MECHANISM"); return(BACKUP_CONF_CHECK_LTSA); }

<BACKUP>"C_PARSER_TYPE"            { backup_count("C_PARSER_TYPE"); return(BACKUP_C_PARSER_TYPE); }
<BACKUP>"C_PARSER_DEFAULT"         { backup_count("C_PARSER_DEFAULT"); return(BACKUP_C_PARSER_DEFAULT); }
<BACKUP>"C_PARSER_CTOOL"           { backup_count("C_PARSER_CTOOL"); return(BACKUP_C_PARSER_CTOOL); }

<BACKUP>"THEOREM_PROVER_USED"      { backup_count("THEOREM_PROVER_USED"); return(BACKUP_THEOREM_PROVER_USED); }
<BACKUP>"THEOREM_PROVER_SIMPLIFY"  { backup_count("THEOREM_PROVER_SIMPLIFY"); return(BACKUP_THEOREM_PROVER_SIMPLIFY); }
<BACKUP>"THEOREM_PROVER_CPROVER"   { backup_count("THEOREM_PROVER_CPROVER"); return(BACKUP_THEOREM_PROVER_CPROVER); }
<BACKUP>"THEOREM_PROVER_CVC"       { backup_count("THEOREM_PROVER_CVC"); return(BACKUP_THEOREM_PROVER_CVC); }
<BACKUP>"THEOREM_PROVER_ICS"       { backup_count("THEOREM_PROVER_ICS"); return(BACKUP_THEOREM_PROVER_ICS); }
<BACKUP>"THEOREM_PROVER_SVC"       { backup_count("THEOREM_PROVER_SVC"); return(BACKUP_THEOREM_PROVER_SVC); }
<BACKUP>"THEOREM_PROVER_CVCL"      { backup_count("THEOREM_PROVER_CVCL"); return(BACKUP_THEOREM_PROVER_CVCL); }

<BACKUP>"SAT_SOLVER_USED"      { backup_count("SAT_SOLVER_USED"); return(BACKUP_SAT_SOLVER_USED); }
<BACKUP>"SAT_SOLVER_CHAFF"     { backup_count("SAT_SOLVER_CHAFF"); return(BACKUP_SAT_SOLVER_CHAFF); }
<BACKUP>"SAT_SOLVER_SATO"      { backup_count("SAT_SOLVER_SATO"); return(BACKUP_SAT_SOLVER_SATO); }
<BACKUP>"SAT_SOLVER_GRASP"     { backup_count("SAT_SOLVER_GRASP"); return(BACKUP_SAT_SOLVER_GRASP); }
<BACKUP>"SAT_SOLVER_HORN_AI"   { backup_count("SAT_SOLVER_HORN_AI"); return(BACKUP_SAT_SOLVER_HORN_AI); }

<BACKUP>"PATTERN_MATCHER_USED"   { backup_count("PATTERN_MATCHER_USED"); return(BACKUP_PATTERN_MATCHER_USED); }
<BACKUP>"PATTERN_MATCHER_NAIVE"  { backup_count("PATTERN_MATCHER_NAIVE"); return(BACKUP_PATTERN_MATCHER_NAIVE); }

<BACKUP>"IGNORE_POINTERS"       { backup_count("IGNORE_POINTERS"); return(BACKUP_IGNORE_POINTERS); }
<BACKUP>"USE_SYNTACTIC_CHECKS"  { backup_count("USE_SYNTACTIC_CHECKS"); return(BACKUP_USE_SYNTACTIC_CHECKS); }
<BACKUP>"THEOREM_PROVER_CACHE"  { backup_count("THEOREM_PROVER_CACHE"); return(BACKUP_THEOREM_PROVER_CACHE); }

<BACKUP>"THEOREM_PROVER_CACHE_SIZE"  { backup_count("THEOREM_PROVER_CACHE_SIZE"); return(BACKUP_THEOREM_PROVER_CACHE_SIZE); }
<BACKUP>"USE_PAM"                    { backup_count("USE_PAM"); return(BACKUP_USE_PAM); }
<BACKUP>"PREDS_FROM_SPEC"            { backup_count("PREDS_FROM_SPEC"); return(BACKUP_PREDS_FROM_SPEC); }
<BACKUP>"INIT_SEEDS_FROM_SPEC"       { backup_count("INIT_SEEDS_FROM_SPEC"); return(BACKUP_INIT_SEEDS_FROM_SPEC); }
<BACKUP>"PREDS_FROM_CE"              { backup_count("PREDS_FROM_CE"); return(BACKUP_PREDS_FROM_CE); }
<BACKUP>"VERBOSITY_LEVEL"            { backup_count("VERBOSITY_LEVEL"); return(BACKUP_VERBOSITY_LEVEL); }
<BACKUP>"HANDLE_DATA_COMM"           { backup_count("HANDLE_DATA_COMM"); return(BACKUP_HANDLE_DATA_COMM); }

<BACKUP>"USE_LIVE_VARS"		     { backup_count("USE_LIVE_VARS"); return(BACKUP_USE_LIVE_VARS); }
<BACKUP>"INLINE_LIBS"		     { backup_count("INLINE_LIBS"); return(BACKUP_INLINE_LIBS); }
<BACKUP>"CHECK_INVALID_PTR_DEREF"    { backup_count("CHECK_INVALID_PTR_DEREF"); return(BACKUP_CHECK_INVALID_PTR_DEREF); }
<BACKUP>"CHECK_ASSERTION_FAILURE"    { backup_count("CHECK_ASSERTION_FAILURE"); return(BACKUP_CHECK_ASSERTION_FAILURE); }
<BACKUP>"START_ITER"		     { backup_count("START_ITER"); return(BACKUP_START_ITER); }
<BACKUP>"END_ITER"		     { backup_count("END_ITER"); return(BACKUP_END_ITER); }
<BACKUP>"USE_REACH_IMPL"	     { backup_count("USE_REACH_IMPL"); return(BACKUP_USE_REACH_IMPL); }
<BACKUP>"PRECOMPUTE_IMPL_TRANS"	     { backup_count("PRECOMPUTE_IMPL_TRANS"); return(BACKUP_PRECOMPUTE_IMPL_TRANS); }
<BACKUP>"CACHE_IMPL_TRANS"	     { backup_count("CACHE_IMPL_TRANS"); return(BACKUP_CACHE_IMPL_TRANS); }
<BACKUP>"SIM_REL_FROM_SAT"	     { backup_count("SIM_REL_FROM_SAT"); return(BACKUP_SIM_REL_FROM_SAT); }
<BACKUP>"PREOPTIMIZE"		     { backup_count("PREOPTIMIZE"); return(BACKUP_PREOPTIMIZE); }
<BACKUP>"PREOPTVISIT"		     { backup_count("PREOPTVISIT"); return(BACKUP_PREOPTVISIT); }
<BACKUP>"PREOPTVISITS"		     { backup_count("PREOPTVISITS"); return(BACKUP_PREOPTVISITS); }
<BACKUP>"PREOPTMINDEPTH"	     { backup_count("PREOPTMINDEPTH"); return(BACKUP_PREOPTMINDEPTH); }
<BACKUP>"PREOPTMINCES"		     { backup_count("PREOPTMINCES"); return(BACKUP_PREOPTMINCES); }
<BACKUP>"PREOPTMAXDEPTH"	     { backup_count("PREOPTMAXDEPTH"); return(BACKUP_PREOPTMAXDEPTH); }
<BACKUP>"PREOPTMAXCES"		     { backup_count("PREOPTMAXCES"); return(BACKUP_PREOPTMAXCES); }
<BACKUP>"COVERAGE"		     { backup_count("COVERAGE"); return(BACKUP_COVERAGE); }
<BACKUP>"COVERCONT"		     { backup_count("COVERCONT"); return(BACKUP_COVERCONT); }
<BACKUP>"SHOWCOVER"		     { backup_count("SHOWCOVER"); return(BACKUP_SHOWCOVER); }
<BACKUP>"CEGAR"			     { backup_count("CEGAR"); return(BACKUP_CEGAR); }

<BACKUP>"CEGAR_TYPE"		     { backup_count("CEGAR_TYPE"); return(BACKUP_CEGAR_TYPE); }
<BACKUP>"CEGAR_ELIMINATE_PRED"	     { backup_count("CEGAR_ELIMINATE_PRED"); return(BACKUP_CEGAR_ELIMINATE_PRED); }
<BACKUP>"CEGAR_USEFUL_PRED"	     { backup_count("CEGAR_USEFUL_PRED"); return(BACKUP_CEGAR_USEFUL_PRED); }
<BACKUP>"CEGAR_OPTIMIZE_PRED"	     { backup_count("CEGAR_OPTIMIZE_PRED"); return(BACKUP_CEGAR_OPTIMIZE_PRED); }
<BACKUP>"CEGAR_GREEDY_PRED"	     { backup_count("CEGAR_GREEDY_PRED"); return(BACKUP_CEGAR_GREEDY_PRED); }

<BACKUP>"INC_VERIFY"		     { backup_count("INC_VERIFY"); return(BACKUP_INC_VERIFY); }
<BACKUP>"MAX_ADD_PRED"		     { backup_count("MAX_ADD_PRED"); return(BACKUP_MAX_ADD_PRED); }
<BACKUP>"CHECK_CE_BRANCHING"	     { backup_count("CHECK_CE_BRANCHING"); return(BACKUP_CHECK_CE_BRANCHING); }

<BACKUP>"PATH_CHECK_TYPE"	     { backup_count("PATH_CHECK_TYPE"); return(BACKUP_PATH_CHECK_TYPE); }
<BACKUP>"PATH_CHECK_FORWARD"	     { backup_count("PATH_CHECK_FORWARD"); return(BACKUP_PATH_CHECK_FORWARD); }
<BACKUP>"PATH_CHECK_BACKWARD"	     { backup_count("PATH_CHECK_BACKWARD"); return(BACKUP_PATH_CHECK_BACKWARD); }

<BACKUP>"CE_DISPLAY_TYPE"	     { backup_count("CE_DISPLAY_TYPE"); return(BACKUP_CE_DISPLAY_TYPE); }
<BACKUP>"CE_LOC_ONLY"		     { backup_count("CE_LOC_ONLY"); return(BACKUP_CE_LOC_ONLY); }
<BACKUP>"CE_LOC_ACT"		     { backup_count("CE_LOC_ACT"); return(BACKUP_CE_LOC_ACT); }
<BACKUP>"CE_LOC_CONS"		     { backup_count("CE_LOC_CONS"); return(BACKUP_CE_LOC_CONS); }
<BACKUP>"CE_LOC_CONS_ACT"	     { backup_count("CE_LOC_CONS_ACT"); return(BACKUP_CE_LOC_CONS_ACT); }

<BACKUP>"CHECK_CE_VALIDITY"	     { backup_count("CHECK_CE_VALIDITY"); return(BACKUP_CHECK_CE_VALIDITY); }
<BACKUP>"USE_PATTERN_MATCHER"	     { backup_count("USE_PATTERN_MATCHER"); return(BACKUP_USE_PATTERN_MATCHER); }
<BACKUP>"MAX_GLOBAL_CE"		     { backup_count("MAX_GLOBAL_CE"); return(BACKUP_MAX_GLOBAL_CE); }
<BACKUP>"MAX_CE_LOOP"		     { backup_count("MAX_CE_LOOP"); return(BACKUP_MAX_CE_LOOP); }
<BACKUP>"CE_NEW_NODE_PROB"	     { backup_count("CE_NEW_NODE_PROB"); return(BACKUP_CE_NEW_NODE_PROB); }
<BACKUP>"CNF_NO_NEW_VARS"	     { backup_count("CNF_NO_NEW_VARS"); return(BACKUP_CNF_NO_NEW_VARS); }
<BACKUP>"LARGEST_SUBSET"	     { backup_count("LARGEST_SUBSET"); return(BACKUP_LARGEST_SUBSET); }
<BACKUP>"SMALLEST_SUBSET"	     { backup_count("SMALLEST_SUBSET"); return(BACKUP_SMALLEST_SUBSET); }
<BACKUP>"SUBSET_CUTOFF"		     { backup_count("SUBSET_CUTOFF"); return(BACKUP_SUBSET_CUTOFF); }
<BACKUP>"CONSTRAINT_CUTOFF"	     { backup_count("CONSTRAINT_CUTOFF"); return(BACKUP_CONSTRAINT_CUTOFF); }
<BACKUP>"STOP_OPT_AFTER_ELIM"	     { backup_count("STOP_OPT_AFTER_ELIM"); return(BACKUP_STOP_OPT_AFTER_ELIM); }
<BACKUP>"USE_PRED_ABSTRACTION"	     { backup_count("USE_PRED_ABSTRACTION"); return(BACKUP_USE_PRED_ABSTRACTION); }
<BACKUP>"USE_LTS_ABSTRACTION"	     { backup_count("USE_LTS_ABSTRACTION"); return(BACKUP_USE_LTS_ABSTRACTION); }
<BACKUP>"NO_USELESS_LOCS"	     { backup_count("NO_USELESS_LOCS"); return(BACKUP_NO_USELESS_LOCS); }
<BACKUP>"NO_SILENT_TRANS"	     { backup_count("NO_SILENT_TRANS"); return(BACKUP_NO_SILENT_TRANS); }
<BACKUP>"MAX_PRED_INFER_LOOP"	     { backup_count("MAX_PRED_INFER_LOOP"); return(BACKUP_MAX_PRED_INFER_LOOP); }
<BACKUP>"MAX_TIME_LIMIT"	     { backup_count("MAX_TIME_LIMIT"); return(BACKUP_MAX_TIME_LIMIT); }
<BACKUP>"LTL_TO_BUCHI"		     { backup_count("LTL_TO_BUCHI"); return(BACKUP_LTL_TO_BUCHI); }
<BACKUP>"CREATE_DOT_FILE"	     { backup_count("CREATE_DOT_FILE"); return(BACKUP_CREATE_DOT_FILE); }
<BACKUP>"DRAW_LTS"		     { backup_count("DRAW_LTS"); return(BACKUP_DRAW_LTS); }
<BACKUP>"DRAW_CFG"		     { backup_count("DRAW_CFG"); return(BACKUP_DRAW_CFG); }
<BACKUP>"DRAW_INFERRED_PREDS"	     { backup_count("DRAW_INFERRED_PREDS"); return(BACKUP_DRAW_INFERRED_PREDS); }
<BACKUP>"DRAW_PRED_ABS_LTS"	     { backup_count("DRAW_PRED_ABS_LTS"); return(BACKUP_DRAW_PRED_ABS_LTS); }
<BACKUP>"DRAW_LTS_ABS_LTS"	     { backup_count("DRAW_LTS_ABS_LTS"); return(BACKUP_DRAW_LTS_ABS_LTS); }
<BACKUP>"DRAW_COMPOSED_LTS"	     { backup_count("DRAW_COMPOSED_LTS"); return(BACKUP_DRAW_COMPOSED_LTS); }
<BACKUP>"DRAW_CE_DAG"		     { backup_count("DRAW_CE_DAG"); return(BACKUP_DRAW_CE_DAG); }
<BACKUP>"DRAW_CE_PROJ_LTS"	     { backup_count("DRAW_CE_PROJ_LTS"); return(BACKUP_DRAW_CE_PROJ_LTS); }
<BACKUP>"DRAW_CE_PROJ_PRED"	     { backup_count("DRAW_CE_PROJ_PRED"); return(BACKUP_DRAW_CE_PROJ_PRED); }
<BACKUP>"OUTPUT_MODELS"		     { backup_count("OUTPUT_MODELS"); return(BACKUP_OUTPUT_MODELS); }

<BACKUP>"OUTPUT_MODEL_TYPE"	     { backup_count("OUTPUT_MODEL_TYPE"); return(BACKUP_OUTPUT_MODEL_TYPE); }
<BACKUP>"OUTPUT_MODEL_FSP"	     { backup_count("OUTPUT_MODEL_FSP"); return(BACKUP_OUTPUT_MODEL_FSP); }

<BACKUP>"EXPLAIN_CE"		     { backup_count("EXPLAIN_CE"); return(BACKUP_EXPLAIN_CE); }
<BACKUP>"ADDITIONAL_UNWIND"	     { backup_count("ADDITIONAL_UNWIND"); return(BACKUP_ADDITIONAL_UNWIND); }
<BACKUP>"MAX_UNWIND"		     { backup_count("MAX_UNWIND"); return(BACKUP_MAX_UNWIND); }
<BACKUP>"MORE_UNWIND"		     { backup_count("MORE_UNWIND"); return(BACKUP_MORE_UNWIND); }
<BACKUP>"SPURIOUS_TRIES"	     { backup_count("SPURIOUS_TRIES"); return(BACKUP_SPURIOUS_TRIES); }
<BACKUP>"ACTION_WEIGHT"		     { backup_count("ACTION_WEIGHT"); return(BACKUP_ACTION_WEIGHT); }
<BACKUP>"PRED_WEIGHT"		     { backup_count("PRED_WEIGHT"); return(BACKUP_PRED_WEIGHT); }
<BACKUP>"LTL_NEG"		     { backup_count("LTL_NEG"); return(BACKUP_LTL_NEG); }

<BACKUP>{L}({L}|{D})*     { backup_count("ID_OR_TYPE_NAME"); CSymbolTable::buffer = Backuptext; return(BACKUP_IDENTIFIER); }
<BACKUP>[$]{D}+           { backup_count("DUMMY_VAR"); CSymbolTable::buffer = Backuptext; return(BACKUP_DUMMY_VAR); }
<BACKUP>[$]({L}|{D})*     { backup_count("IDENTIFIER"); CSymbolTable::buffer = Backuptext; return(BACKUP_IDENTIFIER); }

<BACKUP>({L}({L}|{D})+(#({D}+))?::)*{UL}({L}|{D})*     { backup_count("UPPER_ID"); CSymbolTable::buffer = Backuptext; return(BACKUP_UPPER_ID); }
<BACKUP>({L}({L}|{D})+(#({D}+))?::)*{LL}({L}|{D})*     { backup_count("LOWER_ID"); CSymbolTable::buffer = Backuptext; return(BACKUP_LOWER_ID); }

<BACKUP>0[xX]{H}+{IS}?	   { backup_count("INT_CONSTANT"); CSymbolTable::longbuf = strtol(Backuptext,NULL,0); return(BACKUP_INT_CONSTANT); }
<BACKUP>0{D}+{IS}?	   { backup_count("INT_CONSTANT"); CSymbolTable::longbuf = strtol(Backuptext,NULL,0); return(BACKUP_INT_CONSTANT); }
<BACKUP>{D}+{IS}?	   { backup_count("INT_CONSTANT"); CSymbolTable::longbuf = strtol(Backuptext,NULL,0); return(BACKUP_INT_CONSTANT); }
<BACKUP>L?'(\\.|[^\\'])+'  { backup_count("CONSTANT"); CSymbolTable::buffer = Backuptext; return(BACKUP_CONSTANT); }

<BACKUP>{D}+{E}{FS}?		{ backup_count("CONSTANT"); CSymbolTable::buffer = Backuptext; return(BACKUP_CONSTANT); }
<BACKUP>{D}*"."{D}+({E})?{FS}?	{ backup_count("CONSTANT"); CSymbolTable::buffer = Backuptext; return(BACKUP_CONSTANT); }
<BACKUP>{D}+"."{D}*({E})?{FS}?	{ backup_count("CONSTANT"); CSymbolTable::buffer = Backuptext; return(BACKUP_CONSTANT); }

<BACKUP>L?\"(\\.|[^\\"])*\"     { 
                                  backup_count("STRING"); 
                                  if(YY_START == BACKUP) {
                                    CSymbolTable::buffer = Backuptext; 
                                    return(BACKUP_STRING_LITERAL);
                                  } else assert(false);
                                }

<BACKUP>">>="			{ backup_count("RIGHT_ASSIGN"); return(BACKUP_RIGHT_ASSIGN); }
<BACKUP>"<<="			{ backup_count("LEFT_ASSIGN"); return(BACKUP_LEFT_ASSIGN); }
<BACKUP>"+="			{ backup_count("ADD_ASSIGN"); return(BACKUP_ADD_ASSIGN); }
<BACKUP>"-="			{ backup_count("SUB_ASSIGN"); return(BACKUP_SUB_ASSIGN); }
<BACKUP>"*="			{ backup_count("MUL_ASSIGN"); return(BACKUP_MUL_ASSIGN); }
<BACKUP>"/="			{ backup_count("DIV_ASSIGN"); return(BACKUP_DIV_ASSIGN); }
<BACKUP>"%="			{ backup_count("MOD_ASSIGN"); return(BACKUP_MOD_ASSIGN); }
<BACKUP>"&="			{ backup_count("AND_ASSIGN"); return(BACKUP_AND_ASSIGN); }
<BACKUP>"^="			{ backup_count("XOR_ASSIGN"); return(BACKUP_XOR_ASSIGN); }
<BACKUP>"|="			{ backup_count("OR_ASSIGN"); return(BACKUP_OR_ASSIGN); }
<BACKUP>">>"			{ backup_count("RIGHT_OP"); return(BACKUP_RIGHT_OP); }
<BACKUP>"<<"			{ backup_count("LEFT_OP"); return(BACKUP_LEFT_OP); }
<BACKUP>"++"			{ backup_count("INC_OP"); return(BACKUP_INC_OP); }
<BACKUP>"--"			{ backup_count("DEC_OP"); return(BACKUP_DEC_OP); }
<BACKUP>"->"			{ backup_count("PTR_OP"); return(BACKUP_PTR_OP); }
<BACKUP>"&&"			{ backup_count("AND_OP"); return(BACKUP_AND_OP); }
<BACKUP>"||"			{ backup_count("OR_OP"); return(BACKUP_OR_OP); }
<BACKUP>"<="			{ backup_count("LE_OP"); return(BACKUP_LE_OP); }
<BACKUP>">="			{ backup_count("GE_OP"); return(BACKUP_GE_OP); }
<BACKUP>"=="			{ backup_count("EQ_OP"); return(BACKUP_EQ_OP); }
<BACKUP>"!="			{ backup_count("NE_OP"); return(BACKUP_NE_OP); }
<BACKUP>";"	                {
                                  backup_count(";"); 
                                  if(YY_START == BACKUP) return(';');
                                  else assert(false);
                                }
<BACKUP>("{"|"<%")	        { backup_count("{"); CSymbolTable::PushScope(); return('{'); }
<BACKUP>("}"|"%>")	        { backup_count("}"); CSymbolTable::PopScope(); return('}'); }
<BACKUP>","		        { backup_count(","); return(','); }
<BACKUP>":"		        { backup_count(":"); return(':'); }
<BACKUP>"="		        { backup_count("="); return('='); }
<BACKUP>"("                     {
                                  backup_count("("); 
			          if(YY_START == BACKUP) return('(');
				  else assert(false);
			        } 
<BACKUP>")"                     { 
                                  backup_count(")"); 
			          if(YY_START == BACKUP) return(')');
			          else assert(false);
			        }
<BACKUP>("["|"<:")	        { backup_count("["); return('['); }
<BACKUP>("]"|":>")	        { backup_count("]"); return(']'); }
<BACKUP>"."	        	{ backup_count("."); return('.'); }
<BACKUP>"&"		        { backup_count("&"); return('&'); }
<BACKUP>"!"		        { backup_count("!"); return('!'); }
<BACKUP>"~"		        { backup_count("~"); return('~'); }
<BACKUP>"-"			{ backup_count("-"); return('-'); }
<BACKUP>"+"		        { backup_count("+"); return('+'); }
<BACKUP,COMMENT>"*"             { backup_count("*"); if(YY_START == BACKUP) { return('*'); } }
<BACKUP,COMMENT>"/"       	{ backup_count("/"); if(YY_START == BACKUP) { return('/'); } }
<BACKUP>"%"		        { backup_count("%"); return('%'); }
<BACKUP>"<"		        { backup_count("<"); return('<'); }
<BACKUP>">"		        { backup_count(">"); return('>'); }
<BACKUP>"^"			{ backup_count("^"); return('^'); }
<BACKUP>"|"		        { backup_count("|"); return('|'); }
<BACKUP>"?"			{ backup_count("?"); return('?'); }
<BACKUP>"!!"			{ backup_count("BANG_BANG"); return(BACKUP_BANG_BANG); }

<BACKUP>({L}|{D}|"-"|"."|"/")+  { backup_count("FILE_NAME"); CSymbolTable::buffer = Backuptext; return(BACKUP_FILE_NAME); }

<BACKUP>[ \t\v\n\f\r]	        { backup_count("WHITE_SPACE"); }
<*>.    			{ printf("unknown character ...\n"); GlobalShutdown(-1); }
%%

int backup_lineNum = 1,backup_column = 0;

void backup_count(const char *message)
{
  int i;  
  for(i = 0; Backuptext[i] != '\0'; ++i)
    if(Backuptext[i] == '\n') {
      ++backup_lineNum;
      backup_column = 0;
    } else if(Backuptext[i] == '\t') backup_column += 8 - (backup_column % 8);
    else ++backup_column;
  if(Database::PARSE_ECHO) ECHO;
}

//to prevent the warning message that yyunput() is unused
void BackupDummy() { yyunput(0,NULL); }

/*********************************************************************/
//end of BackupLexer.cpp
/*********************************************************************/

