/**************************** CPPHeaderFile ***************************

* FileName [Alias.h]

* PackageName [parser]

* Synopsis [Header file for Alias class.]

* Description [This class encapsulates an aliasing scenario.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __ALIAS_H__
#define __ALIAS_H__

namespace magic {

//other classes needed
class Expr;
class ExprList;

class Alias
{
 private:
  //the pointer
  Expr pointer;

  //the points-to set
  set<Expr> pointsTo;

 public:
  Alias() {}
  Alias(const BasicExpr *e,const ExprList *l);
  Alias(const Alias &rhs) { *this = rhs; }
  const Alias &operator = (const Alias &rhs);

  set<string> FindPointsTo(const string &ptr) const;
};

} //namespace magic

#endif //__ALIAS_H__

/*********************************************************************/
//end of Alias.h
/*********************************************************************/
