/******************************** CPPFile *****************************

* FileName [Alias.cpp]

* PackageName [parser]

* Synopsis [Method definitions of Alias class.]

* SeeAlso [Alias.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <map>
#include <vector>
using namespace std;

#include "Util.h"
#include "Node.h"
#include "Alias.h"
using namespace magic;

/*********************************************************************/
//constructor
/*********************************************************************/
Alias::Alias(const BasicExpr *e,const ExprList *l)
{
  pointer = Expr(e);
  for(list<BasicExpr*>::const_iterator i = l->data.begin();i != l->data.end();++i) {
    pointsTo.insert(Expr(*i));
  }
}

/*********************************************************************/
//operators
/*********************************************************************/
const Alias &Alias::operator = (const Alias &rhs)
{
  pointer = rhs.pointer;
  pointsTo = rhs.pointsTo;
  return *this;
}

/*********************************************************************/
//find the set of strings that the argument lvalue points to
/*********************************************************************/
set<string> Alias::FindPointsTo(const string &ptr) const
{
  set<string> res;
  if(ptr == Util::TrimString(pointer.ToString())) {
    for(set<Expr>::const_iterator i = pointsTo.begin();i != pointsTo.end();++i) {
      res.insert(Util::TrimString(i->ToString()));
    }
  }
  return res;
}

/*********************************************************************/
//end of Alias.cpp
/*********************************************************************/
