/**************************** CPPHeaderFile ***************************

* FileName [Action.h]

* PackageName [parser]

* Synopsis [Header file for Action class.]

* Description [This class encapsulates an action.]

* SeeAlso []

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __ACTION_H__
#define __ACTION_H__

namespace magic {

//other classes needed
class Expr;
class DeclStmt;
class DeclStmtList;
class ProcAbs;
class BasicLtl;

class Action
{
 private:
  //the index of the action
  short index;

 public:
  static const int ACTION_NONE;

  //default constructor
  Action() { index = ACTION_NONE; }
  //creating an action from an id
  Action(short i);
  //for creating a basic action
  Action(const string &n);
  //for creating a return action
  Action(const Expr &e);
  //for creating an assign action
  Action(const Expr &e1,const Expr &e2);
  //for creating a channel action
  Action(const int t,const string &n,const list<Expr> &ca);
  Action(const int t,const string &n,const ExprList &ca);

  Action(const Action &rhs) { *this = rhs; }
  virtual ~Action() {}
  const Action &operator = (const Action &rhs);
  bool operator == (const Action &rhs) const;
  bool operator < (const Action &rhs) const;

  const string &GetName() const;
  short GetIndex() const { return index; }
  const Expr &GetRetExpr() const;
  const Expr &GetLhsExpr() const;
  const Expr &GetRhsExpr() const;
  const string &GetChannel() const;
  const list<Expr> &GetMessage() const;
  const list<Expr> &GetStore() const;

  string ToString() const;

  bool IsSpecEpsilon() const;
  bool IsDefaultRet() const;

  bool IsBasic() const;
  bool IsReturn() const;
  bool IsAssign() const;
  bool IsInvalidPtrDeref() const;
  bool IsAssertionFailure() const;
  bool IsBcast() const;
  bool IsSend() const;
  bool IsRecv() const;
  bool IsComplement() const { return (index < 0); }

  bool ReturnActionPossible(const Expr &retExpr,const list<string> &params,
			    const set<Expr> &context) const;
  bool AssignActionPossible(const Expr &lhs,const Expr &rhs,
			    const list<string> &params,const set<Expr> &context) const;
  Expr GetConcreteReturnExpr(const list<Expr> &args) const;
  pair<Expr,Expr> GetConcreteAssignExprs(const list<Expr> &args) const;
  Action Complement() const;
};

} //namespace magic

#endif //__ACTION_H__

/*********************************************************************/
//end of Action.h
/*********************************************************************/
