/******************************** CPPFile *****************************

* FileName [PaccProp.cpp]

* PackageName [pacc]

* Synopsis [Method definitions of PaccProp class.]

* SeeAlso [PaccAPI.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <string>
#include <list>
#include <set>
#include <map>
#include <vector>
using namespace std;

#include "Node.h"
#include "Action.h"
#include "Component.h"
#include "PaccAPI.h"
using namespace magic;

/*********************************************************************/
//constructors and destructors
/*********************************************************************/
PaccProp::PaccProp() {}

PaccProp::PaccProp(const PaccProp &rhs) { *this = rhs; }

PaccProp::~PaccProp() {}

/*********************************************************************/
//operators
/*********************************************************************/
const PaccProp &PaccProp::operator = (const PaccProp &rhs)
{
  prop = rhs.prop;
  return *this;
}

bool PaccProp::operator == (const PaccProp &rhs) const
{
  return (prop == rhs.prop);
}

bool PaccProp::operator < (const PaccProp &rhs) const
{
  return (prop < rhs.prop);
}

/*********************************************************************/
//conversion from PACC to MAGIC and vice-versa
/*********************************************************************/
Expr PaccProp::ToMagic(const PaccProp &arg)
{
  return arg.prop;
}

PaccProp PaccProp::ToPacc(const Expr &arg)
{
  PaccProp res;
  res.prop = arg;
  return res;
}

/*********************************************************************/
//end of PaccProp.cpp
/*********************************************************************/
