/******************************** CPPFile *****************************

* FileName [PaccAct.cpp]

* PackageName [pacc]

* Synopsis [Method definitions of PaccAct class.]

* SeeAlso [PaccAPI.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <string>
#include <list>
#include <set>
#include <map>
#include <vector>
using namespace std;

#include "Node.h"
#include "Action.h"
#include "Component.h"
#include "PaccAPI.h"
using namespace magic;

/*********************************************************************/
//constructors and destructors
/*********************************************************************/
PaccAct::PaccAct() {}

PaccAct::PaccAct(const PaccAct &rhs) { *this = rhs; }

PaccAct::~PaccAct() {}

/*********************************************************************/
//operators
/*********************************************************************/
const PaccAct &PaccAct::operator = (const PaccAct &rhs)
{
  action = rhs.action;
  return *this;
}

bool PaccAct::operator == (const PaccAct &rhs) const
{
  return (action == rhs.action);
}

bool PaccAct::operator < (const PaccAct &rhs) const
{
  return (action < rhs.action);
}

/*********************************************************************/
//conversion from PACC to MAGIC and vice-versa
/*********************************************************************/
Action PaccAct::ToMagic(const PaccAct &arg)
{
  return arg.action;
}

PaccAct PaccAct::ToPacc(const Action &arg)
{
  PaccAct res;
  res.action = arg;
  return res;
}

/*********************************************************************/
//end of PaccAct.cpp
/*********************************************************************/
