/**************************** CPPHeaderFile ***************************

* FileName [WPComputer.h]

* PackageName [main]

* Synopsis [Header file for WPComputer class.]

* Description [This class computes the weakest precondition of an
* expression with respect to a parallel assignment.]

* SeeAlso [WPComputer.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __WPCOMPUTER_H__
#define __WPCOMPUTER_H__

namespace magic {

//other classes needed
class BasicExpr;

class WPComputer
{
 public:
  static BasicExpr *ComputeWP(const BasicExpr *lhs,const BasicExpr *rhs,const BasicExpr *expr);
  static BasicExpr *Replace(const BasicExpr *lhs,const BasicExpr *rhs,const BasicExpr *expr,bool ignoreAddress);
  static BasicExpr *ComputeWP(const list<const BasicExpr*> &lhsList,const list<const BasicExpr*> &rhsList,const BasicExpr *expr);
  static BasicExpr *Replace(const list<const BasicExpr*> &lhsList,const list<const BasicExpr*> &rhsList,const BasicExpr *expr,bool ignoreAddress);
};

} //namespace magic

#endif //__WPCOMPUTER_H__

/*********************************************************************/
//end of WPComputer.h
/*********************************************************************/
