/**************************** CPPHeaderFile ***************************

* FileName [Util.h]

* PackageName [main]

* Synopsis [Header file for various utility routines.]

* SeeAlso [arc.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __UTIL_H__
#define __UTIL_H__

namespace magic {

//other classes needed
class BasicExpr;
class Expr;
class ContLoc;

class Util
{
 private:
  //counter for generating temporary variables
  static int tempVarCounter;

 public:
  //print an error message and quit
  __attribute__ ((noreturn)) static void Error(char *format,...);
  __attribute__ ((noreturn)) static void Error(string message);

  //print an error message
  static void Message(int vl,char *format,...);
  static void Message(int vl,string message);

  //trim a string - remove intial and trailing whitespace
  static string TrimString(const string &s);

  //generate a new temporary variable
  static string NewTempVar();

  //check if the argument string is a temporary variable
  static bool IsTempVar(const string &arg);

  //check if an expression is a procedure call
  static pair<bool,int> IsProcCall(const BasicExpr *arg);
  
  //compute the set of lvalues in an expression and return them as a
  //set of expressions or a set of strings
  static set<Expr> ComputeExprLvalues(const BasicExpr *expr);
  static set<string> ComputeStrLvalues(const BasicExpr *expr);

  //compute the set of lvalues derefernced in an expression and return
  //them as a set of expressions
  static set<Expr> ComputeExprDerefLvalues(const BasicExpr *expr);

  //compute the set of lvalues which are also identifiers and return
  //them as a set of strings
  static set<string> ComputeIdLvalues(const BasicExpr *expr);

  //compute the set of identifiers in an expression
  static set<string> ComputeIds(const BasicExpr *expr);

  //convert a list of expressions to a string
  static string ExprListToString(const list<const BasicExpr*> &arg);

  //escape all occurences of ch in str with a backslash
  static string EscapeCharacter(const string &str,char ch);

  //returns true if the argument is a special predicate
  static bool IsPredicate(const string &arg);

  //compute the lvalue closure
  static void LvalueClosure(const Expr &expr,const set<Expr> &eset,set<Expr> &res);
};

} //namespace magic

#endif //__UTIL_H__

/*********************************************************************/
//end of Util.h
/*********************************************************************/
