/**************************** CPPHeaderFile ***************************

* FileName [TokenCollector.h]

* PackageName [main]

* Synopsis [Header file for TokenCollector class.]

* Description [This class encapsulates a AST walker that computes the
* set of lvalues in an expression.]

* SeeAlso [TokenCollector.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __TOKENCOLLECTOR_H__
#define __TOKENCOLLECTOR_H__

namespace magic {

//other classes needed
class IdExpr;
class DotExpr;
class ArrowExpr;

class TokenCollector : public DFSAdapter
{
 private:
  //type of tokens to be collected
  int type;

  //collected tokens
  set<Expr> tokens;

  //don't want default TokenCollector to be created
  TokenCollector() {}

 public:
  //types of token collectors
  static const int ALL_LVS; //all lvalues
  static const int ALL_IDS; //all identifiers
  static const int DEREF_LVS; //dereferenced lvalues
  static const int ID_LVS; //id lvalues

  TokenCollector(int t) : type(t) {
    assert((t == ALL_LVS) || (t == ALL_IDS) || (t == DEREF_LVS) || (t == ID_LVS));
  }
  TokenCollector(const TokenCollector &rhs) { *this = rhs; }
  virtual ~TokenCollector() {}
  
  const TokenCollector &operator = (const TokenCollector &rhs) {
    type = rhs.type;
    tokens = rhs.tokens;
    return *this;
  }

  const set<Expr> &GetTokens() const { return tokens; }

  //overridden methods
  void outIdExpr(const IdExpr &node);
  void outBrackExpr(const BrackExpr &node);
  void outDotExpr(const DotExpr &node);
  void outArrowExpr(const ArrowExpr &node);
  void outUnaryExpr(const UnaryExpr &node);
};

} //namespace magic

#endif //__TOKENCOLLECTOR_H__

/*********************************************************************/
//end of TokenCollector.h
/*********************************************************************/
