/******************************** CPPFile *****************************

* FileName [TokenCollector.cpp]

* PackageName [main]

* Synopsis [Method definitions of TokenCollector class.]

* SeeAlso [TokenCollector.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <vector>
#include <map>
using namespace std;

#include "Util.h"
#include "Node.h"
#include "DFSAdapter.h"
#include "TokenCollector.h"
using namespace magic;

/*********************************************************************/
//define static fields
/*********************************************************************/
const int TokenCollector::ALL_LVS = 3000;
const int TokenCollector::ALL_IDS = 3010;
const int TokenCollector::DEREF_LVS = 3020;
const int TokenCollector::ID_LVS = 3030;

/*********************************************************************/
//overridden methods
/*********************************************************************/
void TokenCollector::outIdExpr(const IdExpr &node)
{
  if(type == ALL_LVS) tokens.insert(Expr(&node));
  else if(type == ALL_IDS) tokens.insert(Expr(&node));
  else if(type == DEREF_LVS) {}
  else if(type == ID_LVS) tokens.insert(Expr(&node));
  else assert(false);
}

void TokenCollector::outBrackExpr(const BrackExpr &node)
{
  if(type == ALL_LVS) tokens.insert(Expr(&node));
  else if(type == ALL_IDS) {}
  else if(type == DEREF_LVS) { 
    //tokens.insert(ExprManager::GetBinaryExpr(Expr(node.array),Expr(node.index),'+'));
  } else if(type == ID_LVS) {}
  else assert(false);
}

void TokenCollector::outDotExpr(const DotExpr &node)
{
  if(type == ALL_LVS) tokens.insert(Expr(&node));
  else if(type == ALL_IDS) tokens.insert(ExprManager::GetIdExpr(node.id));
  else if(type == DEREF_LVS) {}
  else if(type == ID_LVS) {}
  else assert(false);
}

void TokenCollector::outArrowExpr(const ArrowExpr &node)
{
  if(type == ALL_LVS) tokens.insert(Expr(&node));
  else if(type == ALL_IDS) tokens.insert(ExprManager::GetIdExpr(node.id));
  else if(type == DEREF_LVS) tokens.insert(Expr(node.expr));
  else if(type == ID_LVS) {}
  else assert(false);
}

void TokenCollector::outUnaryExpr(const UnaryExpr &node)
{
  if(type == ALL_LVS) {}
  else if(type == ALL_IDS) {}
  else if(type == DEREF_LVS) {
    if(node.op == '*') tokens.insert(Expr(node.expr));
  } else if(type == ID_LVS) {}
  else assert(false);
}

/*********************************************************************/
//end of TokenCollector.cpp
/*********************************************************************/
