/**************************** CPPHeaderFile ***************************

* FileName [Timer.h]

* PackageName [main]

* Synopsis [Header file for Timer class.]

* Description [This class encapsulates a timer used for making time
* measurements.]

* SeeAlso [Timer.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __TIMER_H__
#define __TIMER_H__

namespace magic {

class Timer
{
 private:
  double start;
  double time;

 public:
  Timer() { start = -1; time = 0; }
  Timer(const Timer &rhs);  
  const Timer &operator = (const Timer &rhs);

  bool Running() const;
  void Start();
  void Stop();
  void Forward(const Timer &arg);
  double Read() const;
};

} //namespace magic

#endif //__TIMER_H__

/*********************************************************************/
//end of Timer.h
/*********************************************************************/
