/**************************** CPPHeaderFile ***************************

* FileName [TheoremProver.h]

* PackageName [main]

* Synopsis [Header file for TheoremProver class.]

* Description [This class provides a set of static methods used by the
* tool to interface with the theorem prover.]

* SeeAlso [TheoremProver.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __THEOREMPROVER_H__
#define __THEOREMPROVER_H__

namespace magic {

//other classes needed
class GenericTP;
class BasicExpr;

class TheoremProver
{
 private:
  //the theorem prover
  static GenericTP *genericTP;
  
 public:
  //initialise the theorem prover
  static void Initialise();
  
  //shutdown the theorem prover
  static void Shutdown();
  
  //add a constraint to the theorem prover environment. this
  //constraint is provided as a C expression.
  static void AddConstraint(const BasicExpr *expr);
  
  //prove that an antecedent implies a consequent. both the antecedent
  //and the consequent are provided as a list of formulas. the result
  //is true if the cojunction of all of the antecedents implies the
  //disjunction of all of the consequents. return true if it can be
  //proved and false otherwise.
  static bool ProveImplies(const list<const BasicExpr*> &ante,const list<const BasicExpr*> &cons);
};

} //namespace magic

#endif //__THEOREMPROVER_H__

/*********************************************************************/
//end of TheoremProver.h
/*********************************************************************/
