/**************************** CPPHeaderFile ***************************

* FileName [Statistics.h]

* PackageName [main]

* Synopsis [Header file for Statistics class.]

* Description [This class encapsulates various statistics collected
* during the execution of the tool.]

* SeeAlso [Statistics.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __STATISTICS_H__
#define __STATISTICS_H__

namespace magic {

//other classes needed
class Timer;
class BigInt;

class Statistics
{
 public:
  static Timer globalTimer;
  static Timer imeTimer;
  static Timer bacTimer;
  static Timer ipTimer;
  static Timer verTimer;
  static Timer arTimer;
  static Timer cegTimer;
  static Timer cevTimer;
  static Timer parTimer;
  static Timer larTimer;
  static Timer exUnwindTimer;
  static Timer exSearchTimer;
  static size_t elimCombNum;
  static size_t maxElimCombNum;
  static size_t maxElimCombSize;
  static size_t maxTriedCombSize;
  static int seedNum;
  static BigInt stateNum;
  static int iterNum;
  static int predIterNum;
  static int ltsIterNum;
  static int explainIterDepthNum;
  static int explainIterSpurNum;
  static int tpCalls;
  static int tpInCache;
  static int tpCacheSize;  
  
  Statistics() {}
  static void ShutdownTimers();
  static void Display();
};

} //namespace magic

#endif //__STATISTICS_H__

/*********************************************************************/
//end of Statistics.h
/*********************************************************************/
