/**************************** CPPHeaderFile ***************************

* FileName [SimChecker.h]

* PackageName [main]

* Synopsis [Header file for SimChecker class.]

* Description [This class encapsulates the simulation checker.]

* SeeAlso [SimChecker.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __SIMCHECKER_H__
#define __SIMCHECKER_H__

namespace magic {

//other classes needed
class ContLoc;
class ImplState;
class BigInt;

class SimChecker
{
 private:  
  static bool CheckSimulationExplicit();
  static void ComputeReachableStates(set<int> &res);
  static void RefinePotSimRel();

 public:
  //the map of elements excluded from the maximal simulation relation
  //to the order in which they were excluded
  static map<BigInt,size_t> exclMap;
  
  static bool CheckSimulationProperty();
  static bool CheckReachability();
};

} //namespace magic

#endif //__SIMCHECKER_H__

/*********************************************************************/
//end of SimChecker.h
/*********************************************************************/
