/******************************** CPPFile *****************************

* FileName [SimChecker.cpp]

* PackageName [main]

* Synopsis [Method definitions of SimChecker class.]

* SeeAlso [SimChecker.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cstdio>
#include <cassert>
#include <gmp.h>
#include <string>
#include <list>
#include <map>
#include <set>
#include <vector>
using namespace std;

#include "BigInt.h"
#include "Util.h"
#include "Node.h"
#include "ProcAbs.h"
#include "LtsInfo.h"
#include "Action.h"
#include "LtsTrans.h"
#include "FspInfo.h"
#include "Database.h"
#include "Predicate.h"
#include "PredSet.h"
#include "ContLoc.h"
#include "ProcInfo.h"
#include "ImplState.h"
#ifdef MAGIC_FULL
#include "SAT.h"
#endif //MAGIC_FULL
#include "SatSimChecker.h"
#include "LtsaChecker.h"
#include "SimChecker.h"
using namespace magic;

/*********************************************************************/
//define static fields
/*********************************************************************/
map<BigInt,size_t> SimChecker::exclMap;

/*********************************************************************/
//check for simulation
/*********************************************************************/
bool SimChecker::CheckSimulationProperty()
{
  //clear the maximal simulation related data structures
  exclMap.clear();

  //compute the result of the simulation check
  if(Database::CONF_CHECK_MECHANISM == Database::CONF_CHECK_EXPLICIT) {
    return CheckSimulationExplicit();
  } else if(Database::CONF_CHECK_MECHANISM == Database::CONF_CHECK_SAT) {
    return SatSimChecker::CheckSimulation();
  } else assert(false);
}

/*********************************************************************/
//check reachability of ERROR state
/*********************************************************************/
bool SimChecker::CheckReachability()
{
  //if we are checking reachability using HORNSAT
  if(Database::CONF_CHECK_MECHANISM == Database::CONF_CHECK_SAT) {
    //clear the maximal simulation related data structures
    exclMap.clear();
    return SatSimChecker::CheckReachability();
  } 
  //if we are checking reachability using LTSA
  if(Database::CONF_CHECK_MECHANISM == Database::CONF_CHECK_LTSA) {
    return LtsaChecker::Run();
  }  
  //impossible
  else assert(false);
}

/*********************************************************************/
//check simulation by explicit state method
/*********************************************************************/
bool SimChecker::CheckSimulationExplicit()
{
  //right now we dont allow this
  assert(false);

  //compute the set of reachable states
  set<int> reach; ComputeReachableStates(reach);
  Util::Message(2,"reachable states computed ...\n");
  Util::Message(2,"number of reachable states = %d\n",reach.size());

  //initialise the simulation relation
  
  //refine the potential simulation relation till fixed point is
  //reached
  RefinePotSimRel();
  
  //check the initial condition
  return false;
}

/*********************************************************************/
//compute the set of reachable states
/*********************************************************************/
void SimChecker::ComputeReachableStates(set<int> &res)
{
}

/*********************************************************************/
//refine the potential simulation relation
/*********************************************************************/
void SimChecker::RefinePotSimRel()
{
}

/*********************************************************************/
//end of SimChecker.cpp
/*********************************************************************/
