/**************************** CPPHeaderFile ***************************

* FileName [SeawChecker.h]

* PackageName [main]

* Synopsis [Header file for SeawChecker class.]

* Description [This class encapsulates a model checker for SE-AW formulas.]

* SeeAlso [SeawChecker.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __SEAWCHECKER_H__
#define __SEAWCHECKER_H__

namespace magic {

//other classes needed
class OmegaExpr;
class BasicSeaw;

class SeawChecker
{
 private:
  //set of formulas checked already
  static set<const BasicSeaw*> labeled;

  //map from formulas to states where they hold
  static map< const BasicSeaw*,set<BigInt> > label;

  //the current omega operator formula being verified and the result
  //of constructing its Buchi automamata
  static pair<const BasicSeaw*,int> opSeaw;

  static bool LabelState(const BigInt &state,const BasicSeaw *seaw);
  static void LabelAllStates(const BasicSeaw *seaw);
  static void AGAct(const BasicSeaw *seaw,const Action &act);
  static void AGProp(const BasicSeaw *seaw,const BasicSeaw *prop);
  static void AFAct(const BasicSeaw *seaw,const Action &act);
  static void AFProp(const BasicSeaw *seaw,const BasicSeaw *prop);
  static void CreateBuchi(const BasicSeaw *seaw);

 public:
  static bool CheckSeaw();

  friend class LtlChecker;
};

} //namespace magic

#endif //__SEAWCHECKER_H__

/*********************************************************************/
//end of SeawChecker.h
/*********************************************************************/
