/**************************** CPPHeaderFile ***************************

* FileName [SatSimChecker.h]

* PackageName [main]

* Synopsis [Header file for SatSimChecker class.]

* Description [This class encapsulates a the simulation checker based
* on SAT.]

* SeeAlso [SatSimChecker.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __SATSIMCHECKER_H__
#define __SATSIMCHECKER_H__

namespace magic {

//other classes needed
class Expr;
class Action;
class ProcInfo;


class SatSimChecker
{
#ifdef MAGIC_FULL
 private:
  //the SAT manager
  static SAT_Manager manager;

  static const char DIMACS_FILE[];
  static const char OUTPUT_FILE[];
#endif //MAGIC_FULL

  //the map from actual variables to boolean variables. this is done
  //because not all states are reachable and so that boolean variables
  //lie in a contiguous range.
  static map<BigInt,int> varMap;

  //the map from boolean variables to actual variables. this is
  //maintained as a vector since the range of boolean variables is
  //contiguous
  static vector<BigInt> varVec;

  //the current set of clauses
  static set< set<int> > clauses;  

  //the set of clauses to add and remove
  static set< set<int> > addClauses;  
  static set< set<int> > remClauses;  
  
  static void CreateSatManager();

#ifdef MAGIC_FULL
  static void InitTrueDecision(SAT_Manager mng);
  static void CreateDimacsFile();
  static int SolveSatSato();
  static int SolveSatGrasp();
#endif //MAGIC_FULL

  static void AddClause(const set<BigInt> &clause);
  static void RemoveClause(const set<BigInt> &clause);
  static bool AddNonInitialConstraints();
  static bool AddLiteral(set<BigInt> &clause,const BigInt &lit);
  static bool AddInitialConstraints();
  static bool SolveSat();
  static void DestroySatManager();
  static void CleanupFiles();
  static bool AddInitialReachConstraints();
  static bool AddFinalReachConstraints();
  static bool AddTransReachConstraints();

 public:
  //the value assigned to a variable in a satisfying assignment
  static const int ASSIGNED_TRUE;
  static const int ASSIGNED_FALSE;
  static const int ASSIGNED_UNKNOWN;

  static bool CheckSimulation();
  static bool CheckReachability();
};

} //namespace magic

#endif //__SATSIMCHECKER_H__

/*********************************************************************/
//end of SatSimChecker.h
/*********************************************************************/
