/**************************** CPPHeaderFile ***************************

* FileName [ProcInliner.h]

* PackageName [main]

* Synopsis [Header file for ProcInliner class.]

* Description [This class inlines procedure bodies at unabstracted
* call-sites and associates spec LTS info with abstracted call-sites.]


* SeeAlso [ProcInliner.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __PROCINLINER_H__
#define __PROCINLINER_H__

namespace magic {

//other classes needed
class CallGraph;

class ProcInliner
{
 private:
  static void TopologicalSort(const CallGraph &callGraph,list<string> &sorted);
  static void DFS(const set<string> &all,set<string> &seen,set<string> &done,
		  const map< string,set<string> > &edges,const string &node,
		  list<string> &sorted);
  static void ProcessAssigns(ProcInfo &procInfo,set<ContLoc*> &addedLocs,
			     map< ContLoc*,set<ContLoc*> > &predMap);
  static void ProcessCalls(ProcInfo &procInfo,set<ContLoc*> &addedLocs,set<string> &allFuncs,
			   map< ContLoc*,set<ContLoc*> > &predMap,
			   list< pair<ContLoc*,string> > &inlineList);
  static void InlineProc(ContLoc *callSite,const string &procName,const string &siteId);
     
 public:
  static void Inline(const CallGraph &callGraph);
};

} //namespace magic

#endif //__PROCINLINER_H__

/*********************************************************************/
//end of ProcInliner.h
/*********************************************************************/
