/**************************** CPPHeaderFile ***************************

* FileName [ProcInfo.h]

* PackageName [main]

* Synopsis [Header file for ProcInfo class.]

* Description [This class encapsulates a C procedure. It contains all
* the information about the procedure obtained from the C and
* specification files.]

* SeeAlso [ProcInfo.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __PROCINFO_H__
#define __PROCINFO_H__

namespace magic {

//other classes needed
class CompStmt;
class ExprList;
class Alias;
class ProcAbs;
class ContLoc;
class Proc;
class ProcAddInfo;
class Expr;

class ProcInfo
{
 private:
  //the name of the procedure
  string name;

  //the index of the file containing this procedure definition
  int fileIndex;

  //the ast for the procedure definition
  CompStmt ast;

  //the list of parameters of the procedure
  list<string> params;

  //the list of local variables
  list<string> locals;

  //the list of predicates
  ExprList preds;

  //the list of guards for fair loops
  ExprList fairLoops;

  //the set of names of called procedures to be inlined
  set<string> inlines;

  //the list of aliasing scenarios
  list<Alias> aliases;

  //the list of procedure abstractions for this procedure
  list<ProcAbs> callerAbs;

  //the map of call sites to procedure inlines and procedure
  //abstractions
  map< Expr,pair< set<string>,set<string> > > calleeMap;

  //the depth of the context to be maintained
  unsigned context;

  //the set of control locations of the procedure
  list<ContLoc*> contLocs;

  //the initial control location
  ContLoc *initLoc;

  //the final control location
  ContLoc *finalLoc;

 public:
  ProcInfo();
  ProcInfo(const Proc &pr,const string &fn,const ProcAddInfo &pa);
  ProcInfo(const Proc &pr,const string &fn);
  ProcInfo(const ProcAddInfo &pa);
  ProcInfo(const ProcInfo &rhs);
  ~ProcInfo();
  const ProcInfo &operator = (const ProcInfo &rhs);
  void Cleanup();

  CompStmt &GetAst() { return ast; }
  const CompStmt &GetAst() const { return ast; }
  const list<ContLoc*> &GetContLocs() const { return contLocs; }
  list<ContLoc*> &GetContLocs() { return contLocs; }
  string GetName() const { return name; }
  const ExprList &GetPreds() const { return preds; }
  const ExprList &GetFairLoops() const { return fairLoops; }
  const list<ProcAbs> &GetCallerAbs() const { return callerAbs; }
  ContLoc *GetInitLoc() { return initLoc; }
  ContLoc *GetFinalLoc() { return finalLoc; }
  const list<string> &GetParams() const { return params; }
  const list<string> &GetLocals() const { return locals; }
  map< Expr,pair< set<string>,set<string> > > &GetCalleeMap() { return calleeMap; }

  void AddLocal(const string &l);
  void SetInitLoc(ContLoc *i) { initLoc = i; }
  void SetFinalLoc(ContLoc *f) { finalLoc = f; }
  void SetContLocs(const list<ContLoc*> &cl);

  pair< set<string>,set<string> > GetCallSiteInfo(const Expr &expr,int ind);
  set<string> FindPointsTo(const Expr &ptr,int indCall,int lhsAlias);
  void DisplayContLocs() const;
  set< pair<Expr,string> > GetCallAbsInfo(const Expr &site,const string &proc) const;
  set<string> GetCallAbsLtsNames(const Expr &call,const string &proc,const set<Expr> &context) const;
  Expr GetCallAbsLtsGuard(const Expr &call,const string &proc,const string &ltsName) const;
  void CheckAbstractions();
};

} //namespace magic

#endif //__PROCINFO_H__

/*********************************************************************/
//end of ProcInfo.h
/*********************************************************************/
