/**************************** CPPHeaderFile ***************************

* FileName [ModelExtractor.h]

* PackageName [main]

* Synopsis [Header file for the ModelExtractor class. This class is
* responsible for extracting a finite state LTS model from a C program
* using predicate abstraction and other abstraction guidelines.]

* Description []

* SeeAlso [ModelExtractor.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __MODELEXTRACTOR_H__
#define __MODELEXTRACTOR_H__

namespace magic {

class ModelExtractor
{
 private:
  static void ComputeImplStates(const bool predAbsOnly);

 public:
  static bool Run(const bool predAbsOnly);
};

} //namespace magic

#endif //__MODELEXTRACTOR_H__

/*********************************************************************/
//end of ModelExtractor.h
/*********************************************************************/
