/**************************** CPPHeaderFile ***************************

* FileName [LtsaChecker.h]

* PackageName [main]

* Synopsis [Header file for LtsaChecker class.]

* Description [This class encapsulates a checker that verifies the
* reachability of the ERROR state using the LTSA tool.]

* SeeAlso [LtsaChecker.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __LTSACHECKER_H__
#define __LTSACHECKER_H__

namespace magic {

class LtsaChecker
{
 private:
  static string specLtsName;
  static set< list<Action> > ceList;

 public:
  static void SetSpecLtsName(const string &s) { specLtsName = s; }
  static bool Run();

  friend class GlobalCEDag;
};

} //namespace magic

#endif //__LTSACHECKER_H__

/*********************************************************************/
//end of LtsaChecker.h
/*********************************************************************/
