/******************************** CPPFile *****************************

* FileName [LtsaChecker.cpp]

* PackageName [main]

* Synopsis [Method definitions of LtsaChecker class.]

* SeeAlso [LtsaChecker.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <gmp.h>
#include <string>
#include <list>
#include <vector>
#include <set>
#include <map>
using namespace std;

#include "Util.h"
#include "Statistics.h"
#include "BigInt.h"
#include "Node.h"
#include "Action.h"
#include "Component.h"
#include "GlobalAbsLts.h"
#include "LtsTrans.h"
#include "LtsInfo.h"
#include "Database.h"
#include "LtsaChecker.h"
using namespace magic;

/*********************************************************************/
//define static members
/*********************************************************************/
string LtsaChecker::specLtsName;
set< list<Action> > LtsaChecker::ceList;

/*********************************************************************/
//check for reachability of ERROR state using LTSA. return true if the
//ERROR cannot be reached and false otherwise.
/*********************************************************************/
bool LtsaChecker::Run()
{
  //initialise data structures
  ceList.clear();
  //output the model via stderr
  for(size_t i = 0;i < Database::components.size();++i) Database::components[i]->OutputFsp();
  //output the negated property via stderr
  const LtsInfo &specInfo = Database::GetLtsInfo(specLtsName);
  set<string> states = specInfo.GetStates();
  fprintf(stderr,"property ");
  string currState = specInfo.GetInitState();
  while(!states.empty()) {
    states.erase(currState);
    if((currState != Database::STOP_STATE) && (currState != Database::ERROR_STATE)) {
      list<LtsTrans> outTrans; specInfo.GetOutTrans(currState,outTrans);
      if(outTrans.empty()) {
	fprintf(stderr,"State_%s = ( STOP )",currState.c_str());
      } else {
	fprintf(stderr,"State_%s = ( ",currState.c_str());
	for(list<LtsTrans>::const_iterator i = outTrans.begin();i != outTrans.end();++i) {
	  if((i->GetFinalState() == Database::STOP_STATE) || (i->GetFinalState() == Database::ERROR_STATE)) {
	    fprintf(stderr,"act_%d -> %s ",i->GetAction().GetIndex(),i->GetFinalState().c_str());
	  } else {
	    fprintf(stderr,"act_%d -> State_%s ",i->GetAction().GetIndex(),i->GetFinalState().c_str());
	  }
	  ++i;
	  if(i == outTrans.end()) {
	    fprintf(stderr,") ");
	  } else {
	    fprintf(stderr,"| ");
	  } 
	  --i;
	}
      } 
    }
    if(states.empty()) {
      fprintf(stderr,"\n + {");
      Util::Message(2,"\n + {");
    } else {
      if((currState != Database::STOP_STATE) && (currState != Database::ERROR_STATE)) {      
	fprintf(stderr,",\n");
	Util::Message(2,",\n");
      }
      currState = *(states.begin());
    }
  }
  for(set<Action>::const_iterator i = specInfo.GetActions().begin();i != specInfo.GetActions().end();++i) {
    fprintf(stderr,"act_%d ",i->GetIndex());
    ++i;
    if(i == specInfo.GetActions().end()) {
      fprintf(stderr,"}.\n\n");
    } else {
      fprintf(stderr,", ");
    }
    --i;
  }
  /*
  Action inputAct("input"),dataAct("data"),outputAct("output"),ackAct("ack");
  fprintf(stderr,"property Order = ( act_%d -> act_%d -> act_%d -> act_%d -> Order ).\n\n",
	  inputAct.GetIndex(),dataAct.GetIndex(),outputAct.GetIndex(),ackAct.GetIndex());
  */
  for(size_t i = 0;i < Database::components.size();++i) {
    fprintf(stderr,"|| M%d = (INIT_%d).\n",i + 1,i + 1);
    Util::Message(2,"|| M%d = (INIT_%d).\n",i + 1,i + 1);
  }
  fprintf(stderr,"|| P1 = (State_%s).\n",specInfo.GetInitState().c_str());  
  Util::Message(2,"|| P1 = (State_%s).\n",specInfo.GetInitState().c_str());
  fprintf(stderr,"END_MAGIC_OUTPUT\n");
  Util::Message(2,"END_MAGIC_OUTPUT\n");
  //check if a new counterexample has been created
  char ltsaResponse[128];
  fscanf(stdin,"%s",ltsaResponse);
  if(strcmp(ltsaResponse,"LTSA_PROPERTY_HOLDS")) {
    assert(!strcmp(ltsaResponse,"LTSA_PROPERTY_DOES_NOT_HOLD"));
    //get the counterexample from LTSA. a counterexample is simply a
    //list of actions.
    list<Action> ce;
    char buf[128];
    while(true) {
      fscanf(stdin,"%s",buf);
      if(!strcmp(buf,"END_COUNTEREXAMPLE")) break;
      if(strstr(buf,"initial_") != NULL) continue;
      ce.push_back(Action(atoi(buf + 4)));
      Util::Message(2,"read action %s\n",Action(atoi(buf+4)).ToString().c_str());
    }
    ceList.insert(ce);
    Util::Message(2,"done reading ce ...\n");
    return false;
  } else {
    Util::Message(2,"LTSA said ERROR state unreachable ...\n");
    return true;
  }
}

/*********************************************************************/
//end of LtsaChecker.cpp
/*********************************************************************/
