/**************************** CPPHeaderFile ***************************

* FileName [LtsInfo.h]

* PackageName [main]

* Synopsis [Header file for LtsInfo class.]

* Description [This class encapsulates a labeled transition system.]

* SeeAlso [LtsInfo.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __LTSINFO_H__
#define __LTSINFO_H__

namespace magic {

//other classes needed
class Action;
class LtsTrans;

class LtsInfo
{
 private:
  //the name of the LTS - this is also the name of the initial state
  string name;
  //whether the LTS is useful - if it contains a return or assign
  //action or an action common to the specification LTS
  bool useful;
  //the set of states reachable from the initial state
  set<string> states;
  //the map of states to indices
  map<string,int> statesToIds;
  //the set of actions
  set<Action> actions;
  //the transition relation
  set<LtsTrans> trans;
  //the index of the lts info the global vector
  char index;
  //the action successor map
  map< pair<string,Action>,set<string> > succMap;
  //the action predecessor map
  map< pair<string,Action>,set<string> > predMap;
  
  void ComputeReturnActions(set<Action> &res) const;
  void ComputeAssignActions(set<Action> &res) const;
  void GetSuccsOnAction(const string &source,const Action &action,set<string> &res) const;
  void GetPredsOnAction(const string &source,const Action &action,set<string> &res) const;
  
 public:
  LtsInfo();
  LtsInfo(const string &n,const set<string> &s,const set<Action> &a,const set<LtsTrans> &t);
  LtsInfo(const LtsInfo &rhs);
  const LtsInfo &operator = (const LtsInfo &rhs);
  
  string GetName() const { return name; }
  string GetInitState() const { return name; }
  bool IsUseful() const { return useful; }
  char GetIndex() const { return index; }
  const set<string> &GetStates() const { return states; }
  const set<LtsTrans> &GetTrans() const { return trans; }
  const set<Action> &GetActions() const { return actions; }

  void SetIndex(const char i) { index = i; }
  
  void ComputeUseful();
  void GetAssignActExprs(set< pair<Expr,Expr> > &res) const;
  void GetRetActExprs(set<Expr> &res) const;
  void GetReturnActions(const Expr &expr,const list<string> &params,
			const set<Expr> &context,set<Action> &res) const;
  void GetAssignActions(const Expr &lhs,const Expr &rhs,
			const list<string> &params,
			const set<Expr> &context,set<Action> &res) const;
  void GetOutTrans(const string &source,list<LtsTrans> &res) const;
  void GetSuccsOnActionSpec(const string &source,const Action &action,set<string> &res) const;
  void GetSuccsOnActionSpec(const int source,const Action &action,set<string> &res) const;
  int GetStateId(const string &s) const;
  string GetIdState(const int id) const;
  void Draw() const;
};

} //namespace magic

#endif //__LTSINFO_H__

/*********************************************************************/
//end of LtsInfo.h
/*********************************************************************/
