/**************************** CPPHeaderFile ***************************

* FileName [LtsAbsRefiner.h]

* PackageName [main]

* Synopsis [Header file for LtsAbsRefiner class.]

* Description [This class encapsulates a LTS abstraction refiner for a
* component of the program.]

* SeeAlso [LtsAbsRefiner.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __LTSABSREFINER_H__
#define __LTSABSREFINER_H__

namespace magic {

class LtsAbsRefiner
{
 private:
  //the procedure manager we are concerned with
  ProcManager &procManager;

 public:
  static const int LTS_ABS_REFINED;
  static const int LTS_ABS_NOT_REFINED;

  LtsAbsRefiner(ProcManager &p) : procManager(p) {}
  LtsAbsRefiner(const LtsAbsRefiner &rhs) : procManager(rhs.procManager) {}

  int Run();
};

} //namespace magic

#endif //__LTSABSREFINER_H__

/*********************************************************************/
//end of LtsAbsRefiner.h
/*********************************************************************/
