/******************************** CPPFile *****************************

* FileName [LtlToBuchi.cpp]

* PackageName [main]

* Synopsis [Method definitions of LtlToBuchi class.]

* SeeAlso [LtlToBuchi.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <map>
#include <vector>
using namespace std;

#include "Util.h"
#include "Node.h"
#include "Action.h"
#include "LtlFormula.h"
#include "LtlManager.h"
#include "Buchi.h"
#include "LtlToBuchi.h"
using namespace magic;

/*********************************************************************/
//do all the stuff
/*********************************************************************/
void LtlToBuchi::Run()
{
  size_t formulaeNum = 0;
  double stateNum = 0;

  for(map<string,const BasicLtl*>::const_iterator i = LtlManager::nameToLtl.begin();i != LtlManager::nameToLtl.end();++i) {
    Buchi::Initialize(i->second);
    ++formulaeNum;
    stateNum += Buchi::GetStateNum();
  }

  Util::Message(2,"number of LTL formulae: %d\n",formulaeNum);
  Util::Message(2,"states : total : %lf average : %lf\n",stateNum,stateNum/formulaeNum);
}

/*********************************************************************/
//end of LtlToBuchi.cpp
/*********************************************************************/
