/**************************** CPPHeaderFile ***************************

* FileName [LtlChecker.h]

* PackageName [main]

* Synopsis [Header file for LtlChecker class.]

* Description [This class encapsulates a model checker for LTL
* formulas.]

* SeeAlso [LtlChecker.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __LTLCHECKER_H__
#define __LTLCHECKER_H__

namespace magic {

//other classes needed
class BigInt;

class LtlChecker
{
 private:
  static size_t ssn;
  static set<BigInt> visited1;
  static set<BigInt> visited2;
  static set<BigInt> stack;
  static list< list<BigInt> > statePaths;
  static list< list<Action> > actPaths;
  static set<BigInt> ceStates;
  static bool error;
  static bool done;

  static bool PropCompatible(const BigInt &implState,int specState);
  static void DFS1(const BigInt &node,list<BigInt> &statePath,list<Action> &actPath);
  static void DFS2(const BigInt &node,list<BigInt> &statePath,list<Action> &actPath);
  static void CreateShorterCE(const BigInt &node,list<BigInt> &statePath,list<Action> &actPath);

 public:
  static bool CheckFormula();
  static bool CheckFormula(const BigInt &implInit);

  static bool ActCompatible(const Action &act,int specState);
  
  friend class GlobalCEDag;
};

} //namespace magic

#endif //__LTLCHECKER_H__

/*********************************************************************/
//end of LtlChecker.h
/*********************************************************************/
