/**************************** CPPHeaderFile ***************************

* FileName [InputProcessor.h]

* PackageName [main]

* Synopsis [Header file for the InputProcessor class. This class is
* responsible for processing the input, getting user options and file
* names, parsing the files, constructing the control flow graph and
* creating the necessary predicates at each control location.]

* Description []

* SeeAlso [InputProcessor.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __INPUTPROCESSOR_H__
#define __INPUTPROCESSOR_H__

//need to interface with backup parser
extern FILE *Backupin;
int Backupparse();

namespace magic {

class InputProcessor
{
 private:
  static void Restore();
  static bool RunC(list<ProgAbs>::const_iterator &pait);
  static void ConstructCallGraph(CallGraph &callGraph);
  static void RemoveSkipLocations(const CallGraph &callGraph);
  static ContLoc *GetClosestNonSkipLoc(ContLoc *arg);
  static void RemoveUselessBranches(const CallGraph &callGraph);
  static void DoLiveVarAnalysis();

#ifdef MAGIC_FULL
  static bool RunPacc();
#endif //MAGIC_FULL

 public:
  static bool Run();
};

} //namespace magic

#endif //__INPUTPROCESSOR_H__

/*********************************************************************/
//end of InputProcessor.h
/*********************************************************************/
