/**************************** CPPHeaderFile ***************************

* FileName [ImplState.h]

* PackageName [main]

* Synopsis [Header file for ImplState class.]

* Description [This class encapsulates a state of the implementation
* LTS.]

* SeeAlso [ImplState.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __IMPLSTATE_H__
#define __IMPLSTATE_H__

namespace magic {

//other classes needed
class Action;
class ContLoc;
class PredSet;
class ProcManager;

/*********************************************************************/
//this class encapsulates a state of the model extracted via predicate
//abstraction
/*********************************************************************/
class ImplState
{
 private:
  //the id of the control location
  short contLocId;
  
  //the predicate valuation
  PVal predVal;
  
  //the index of the state of the abstracting spec LTS
  short specStateId;
  
  //the index of the info about the abstracting lts
  char specInfoId;
  
  //the index of the abstract state corresponding to this
  //implementation state
  int absId;

  void GetSuccsAndActionsFinal(const set<Action> &globActs,const set<Action> &chanActs,map< Action,set<const ImplState*> > &res) const;
  void GetSuccsAndActionsReturn(const set<Action> &globActs,const set<Action> &chanActs,map< Action,set<const ImplState*> > &res) const;
  void GetSuccsAndActionsBranch(const set<Action> &globActs,const set<Action> &chanActs,map< Action,set<const ImplState*> > &res) const;
  void GetSuccsAndActionsAssign(const set<Action> &globActs,const set<Action> &chanActs,map< Action,set<const ImplState*> > &res) const;
  void GetSuccsAndActionsCall(const set<Action> &globActs,const set<Action> &chanActs,map< Action,set<const ImplState*> > &res) const;

  inline void ProcessAssignActs(ContLoc *succ,const Expr &lhs,const Expr &rhs,
				const set<Expr> &state,const Expr &assignGuard,
				const set<Expr> &addCons,
				const short fsid,const short fiid,
				map< Action,set<const ImplState*> > &res) const;
  void HandleConstraint(ContLoc *succ,const Expr &cons,const set<Action> &acts,map< Action,set<const ImplState*> > &res) const;
  void HandleAssign(ContLoc *succ,const set<Expr> &addCons,const list<Expr> &lhsList,const list<Expr> &rhsList,
		    const set<Action> &acts,const short fsid,const short fiid,
		    map< Action,set<const ImplState*> > &res) const;
  void HandleGlobalVarAssigns(const set<Action> &globActs,const short fsid,const short fiid,
			      map< Action,set<const ImplState*> > &res) const;
  void HandleInvalidPtrDeref(map< Action,set<const ImplState*> > &res) const;
  void HandleAssertionFailure(map< Action,set<const ImplState*> > &res) const;
  void AddSuccAndActions(const ImplState *succ,const set<Action> &actions,map< Action,set<const ImplState*> > &res) const;
  bool PossibleNextValuation(const set<Expr> &addCons,const list<Expr> &lhsList,const list<Expr> &rhsList,const PredSet &oldPreds,
			     const PVal &oldVal,const PredSet &newPreds,const PVal &newVal) const;

 public:
  ImplState() { assert(false); }
  ImplState(short c,const PVal &p,short ss,char si);
  ImplState(const ImplState &rhs);
  const ImplState &operator = (const ImplState &rhs);

  string ToString() const;

  void GetPropositions(set<Expr> &res) const;
  void GetRefusal(set<Action> &res) const;
  void GetSuccsAndActions(const set<Action> &globActs,const set<Action> &chanActs,map< Action,set<const ImplState*> > &res) const;
  void GetSuccsOnAction(const Action &act,set<const ImplState*> &succs) const;
  void GetPredsOnAction(const Action &act,set<const ImplState*> &preds) const;
  string GetKey() const;
  const PVal &GetPredVal() const { return predVal; }
  short GetSpecStateId() const { return specStateId; }
  short GetSpecInfoId() const { return specInfoId; }
  size_t GetProcManagerId() const;
  const ProcManager &GetProcManager() const;
  ContLoc *GetContLoc() const;
  int GetAbsId() const { return absId; }

  void SetAbsId(int a) { absId = a; }
};

/*********************************************************************/
//this class encapsulates a transition of the model extracted via
//predicate abstraction
/*********************************************************************/
class ImplTrans
{
 public:
  const ImplState *source;
  Action act;
  const ImplState *dest;

  ImplTrans() { source = NULL; dest = NULL; }
  ImplTrans(const ImplState *s,const Action &a,const ImplState *d);
  ImplTrans(const ImplTrans &rhs) { *this = rhs; }
  ~ImplTrans() {}

  const ImplTrans &operator = (const ImplTrans &rhs);
  bool operator == (const ImplTrans &rhs) const;
  bool operator < (const ImplTrans &rhs) const;

  string ToString() const;
};

/*********************************************************************/
//this class encapsulates a path of the model extracted via predicate
//abstraction. a path is a sequence of state-action pairs
/*********************************************************************/
class ImplPath
{
 public:
  list< pair<Action,const ImplState*> > data;

  ImplPath() {}
  ImplPath(const ImplPath &rhs) { *this = rhs; }
  ~ImplPath() {}
  
  const ImplPath &operator = (const ImplPath &rhs);
  bool operator == (const ImplPath &rhs) const;
  bool operator < (const ImplPath &rhs) const;

  void PushBack(const Action &act,const ImplState *is);
  void Append(const ImplPath &rhs);
};

} //namespace magic

#endif //__IMPLSTATE_H__

/*********************************************************************/
//end of ImplState.h
/*********************************************************************/
