/**************************** CPPHeaderFile ***************************

* FileName [HornCheckerAI.h]

* PackageName [main]

* Synopsis [Header file for HornCheckerAI class.]

* Description [This class encapsulates a MAX_NHORNSAT solver based on
* the 1991 paper by Ausiello and Italiano and the Ph.D. thesis of
* Sandeep Shukla.

* SeeAlso [HornCheckerAI.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __HORNCHECKERAI_H__
#define __HORNCHECKERAI_H__

/*********************************************************************/
//a simple node in the hypergraph
/*********************************************************************/
class CompoundNode;

class SimpleNode
{
 public:
  char status;
  list<map<int,SimpleNode>::iterator> sNext;
  list<list<CompoundNode>::iterator> cNext;

  SimpleNode() {}
  SimpleNode(const SimpleNode &rhs) { *this = rhs; }
  const SimpleNode &operator = (const SimpleNode &rhs);
};

/*********************************************************************/
//a compound node in the hypergraph
/*********************************************************************/
class CompoundNode 
{
 public:
  unsigned status;
  list<map<int,SimpleNode>::iterator> sNext;

  CompoundNode() {}
  CompoundNode(const CompoundNode &rhs) { *this = rhs; }
  const CompoundNode &operator = (const CompoundNode &rhs);
};

/*********************************************************************/
//the actual solver
/*********************************************************************/
class HornCheckerAI
{
 private:
  //the true and false nodes
  static map<int,SimpleNode> trueFalse;

  //the array of simple node
  static map<int,SimpleNode> simples;

  //the list of compund nodes
  static map< set<int>,list<CompoundNode> > compounds;

  static void Split(const set<int> &clause,pair< set<int>,set<int> > &dest);
  static void Closure(map<int,SimpleNode>::iterator &node,vector<int> &elim);
  static void Closure(CompoundNode &node,vector<int> &elim);
  static void AddArcToTrue(const set<int> &source);
  static void RemoveArcToTrue(const set<int> &source);
  static void AddArcFromFalse(const int dest);
  static void RemoveArcFromFalse(const int dest);
  static void AddHyperArc(const set<int> &source,const int dest);
  static void RemoveHyperArc(const set<int> &source,const int dest);

 public:
  HornCheckerAI() {}
  static void Initialise();
  static void SetVarNum(int num);
  static void RemoveClause(const set<int> &clause);
  static void AddClause(const set<int> &clause);
  static bool SolveSat(vector<int> &elim);
  static void Cleanup();
};

#endif //__HORNCHECKERAI_H__

/*********************************************************************/
//end of HornCheckerAI.h
/*********************************************************************/
